/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator.zk;

import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.service.coordinator.CoordinatorLostHandle;
import cdjd.com.dremio.service.coordinator.zk.ZKClusterConfig;

class ZKSabotConfig
implements ZKClusterConfig {
    private final SabotConfig config;

    ZKSabotConfig(SabotConfig sabotConfig) {
        this.config = sabotConfig;
    }

    @Override
    public int getConnectionTimeoutMilliSecs() {
        return this.config.getInt("dremio.exec.zk.timeout");
    }

    @Override
    public int getSessionTimeoutMilliSecs() {
        return this.config.getInt("dremio.exec.zk.session.timeout");
    }

    @Override
    public String getRoot() {
        return this.config.getString("dremio.exec.zk.root");
    }

    @Override
    public int getRetryBaseDelayMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.retry.delay.base").intValue();
    }

    @Override
    public long getInitialTimeoutMilliSecs() {
        return this.config.getLong("dremio.exec.zk.retry.initial_timeout_ms");
    }

    @Override
    public int getRetryMaxDelayMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.retry.delay.max").intValue();
    }

    @Override
    public boolean isRetryUnlimited() {
        return this.config.getBoolean("dremio.exec.zk.retry.unlimited");
    }

    @Override
    public boolean isConnectionHandleEnabled() {
        return this.config.getBoolean("dremio.exec.zk.connection_handle.enabled");
    }

    @Override
    public long getRetryLimit() {
        return this.config.getLong("dremio.exec.zk.retry.limit");
    }

    @Override
    public long getElectionTimeoutMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.election.timeout");
    }

    @Override
    public long getElectionPollingMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.election.polling");
    }

    @Override
    public long getElectionDelayForLeaderCallbackMilliSecs() {
        return this.config.getMilliseconds("dremio.exec.zk.election.delay_for_leader_callback");
    }

    @Override
    public CoordinatorLostHandle getConnectionLostHandler() {
        return this.config.getInstance("dremio.coordinator_lost_handle.module.class", CoordinatorLostHandle.class, CoordinatorLostHandle.NO_OP, new Object[0]);
    }

    @Override
    public String getClusterId() {
        return this.config.getString("dremio.exec.cluster-id");
    }

    @Override
    public String getConnection() {
        return this.config.getString("dremio.exec.zk.connect");
    }
}

