/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.service.coordinator.zk;

import cdjd.com.dremio.common.AutoCloseables;
import cdjd.com.dremio.service.coordinator.DistributedSemaphore;
import cdjd.org.apache.curator.framework.CuratorFramework;
import cdjd.org.apache.curator.framework.api.BackgroundPathable;
import cdjd.org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import cdjd.org.apache.curator.framework.recipes.locks.Lease;
import cdjd.org.apache.curator.utils.ZKPaths;
import cdjd.org.apache.zookeeper.KeeperException;
import cdjd.org.apache.zookeeper.WatchedEvent;
import cdjd.org.apache.zookeeper.Watcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZkDistributedSemaphore
implements DistributedSemaphore {
    private static final Logger logger = LoggerFactory.getLogger(ZkDistributedSemaphore.class);
    private final InterProcessSemaphoreV2 semaphore;
    private final Map<DistributedSemaphore.UpdateListener, Void> listeners = Collections.synchronizedMap(new WeakHashMap());
    private final String path;
    private final CuratorFramework client;

    ZkDistributedSemaphore(CuratorFramework client, String path, int numberOfLeases) throws Exception {
        this.semaphore = new InterProcessSemaphoreV2(client, path, numberOfLeases);
        this.path = ZKPaths.makePath(path, "leases");
        this.client = client;
    }

    private boolean setWatcher() throws Exception {
        if (this.client.checkExists().forPath(this.path) != null) {
            ((BackgroundPathable)this.client.getChildren().usingWatcher(t -> this.onEvent(t))).forPath(this.path);
            logger.debug("watcher set for path: {}", (Object)this.path);
            return true;
        }
        logger.debug("path {} not found", (Object)this.path);
        return false;
    }

    private void onEvent(WatchedEvent event) {
        block4: {
            block3: {
                if (event.getType() != Watcher.Event.EventType.NodeChildrenChanged) break block3;
                ArrayList<DistributedSemaphore.UpdateListener> col = new ArrayList<DistributedSemaphore.UpdateListener>(this.listeners.keySet());
                for (DistributedSemaphore.UpdateListener l : col) {
                    l.updated();
                }
                break block4;
            }
            if (event.getType() != Watcher.Event.EventType.None || event.getState() != Watcher.Event.KeeperState.SyncConnected) break block4;
            try {
                this.setWatcher();
            }
            catch (Exception e) {
                logger.error("Failure while re-setting watcher after reconnect.", e);
            }
        }
    }

    @Override
    public boolean hasOutstandingPermits() {
        try {
            return !this.semaphore.getParticipantNodes().isEmpty();
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                logger.debug("No node exception.", e);
                return false;
            }
            logger.warn("exception when semaphore trying to get participant nodes.", e);
            return true;
        }
    }

    @Override
    public DistributedSemaphore.DistributedLease acquire(int permits, long time, TimeUnit unit) throws Exception {
        Collection<Lease> leases = this.semaphore.acquire(permits, time, unit);
        if (leases != null) {
            return new LeasesHolder(leases);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerUpdateListener(DistributedSemaphore.UpdateListener listener) {
        boolean set = true;
        ZkDistributedSemaphore zkDistributedSemaphore = this;
        synchronized (zkDistributedSemaphore) {
            if (this.listeners.isEmpty()) {
                try {
                    set = this.setWatcher();
                }
                catch (Exception e) {
                    logger.warn("Exception occurred while registering listener", e);
                }
            }
        }
        this.listeners.put(() -> {
            try {
                listener.updated();
            }
            catch (Exception e) {
                logger.warn("Exception occurred while notifying listener.", e);
            }
        }, null);
        return set;
    }

    private class LeasesHolder
    implements DistributedSemaphore.DistributedLease {
        private Collection<Lease> leases;

        LeasesHolder(Collection<Lease> leases) {
            this.leases = leases;
        }

        @Override
        public void close() throws Exception {
            AutoCloseables.close(this.leases);
        }
    }
}

