/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.ssl;

import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.collect.ImmutableList;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

class CompositeTrustManager
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final ImmutableList<X509ExtendedTrustManager> trustManagers;

    CompositeTrustManager(ImmutableList<X509ExtendedTrustManager> trustManagers) {
        this.trustManagers = Preconditions.checkNotNull(trustManagers);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.doTrustCheck(tm -> tm.checkClientTrusted(x509Certificates, authType));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.doTrustCheck(tm -> tm.checkServerTrusted(x509Certificates, authType));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])this.trustManagers.stream().flatMap(tm -> Arrays.stream(tm.getAcceptedIssuers())).toArray(X509Certificate[]::new);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s2, Socket socket) throws CertificateException {
        this.doTrustCheck(tm -> tm.checkClientTrusted(x509Certificates, s2, socket));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s2, Socket socket) throws CertificateException {
        this.doTrustCheck(tm -> tm.checkServerTrusted(x509Certificates, s2, socket));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s2, SSLEngine sslEngine) throws CertificateException {
        this.doTrustCheck(tm -> tm.checkClientTrusted(x509Certificates, s2, sslEngine));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s2, SSLEngine sslEngine) throws CertificateException {
        this.doTrustCheck(tm -> tm.checkServerTrusted(x509Certificates, s2, sslEngine));
    }

    private void doTrustCheck(CheckTrustedFunction callback) throws CertificateException {
        CertificateException wrapperException = new CertificateException("Failed to verify the certificate.");
        for (X509ExtendedTrustManager tm : this.trustManagers) {
            try {
                callback.apply(tm);
                return;
            }
            catch (CertificateException ex) {
                wrapperException.addSuppressed(ex);
            }
        }
        throw wrapperException;
    }

    @FunctionalInterface
    private static interface CheckTrustedFunction {
        public void apply(X509ExtendedTrustManager var1) throws CertificateException;
    }
}

