/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.ssl;

import cdjd.com.dremio.ssl.CompositeTrustManager;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(CompositeTrustManagerFactory.class);
    private final CompositeTrustManager trustManager;

    private CompositeTrustManagerFactory(Builder builder) {
        this.trustManager = new CompositeTrustManager((ImmutableList<X509ExtendedTrustManager>)builder.trustManagersBuilder.build());
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.trustManager};
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<X509ExtendedTrustManager> trustManagersBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder addDefaultTrustStore() {
            return this.addTrustStore((KeyStore)null);
        }

        public Builder addTrustStore(KeyStore keyStore) {
            try {
                Builder.toX509TrustManager(keyStore).ifPresent(this.trustManagersBuilder::add);
            }
            catch (KeyStoreException ex) {
                logger.warn("Unable to load KeyStore of type {}", (Object)keyStore, (Object)ex);
            }
            return this;
        }

        @VisibleForTesting
        Builder addTrustStore(Iterable<X509ExtendedTrustManager> managers) {
            this.trustManagersBuilder.addAll((Iterable)managers);
            return this;
        }

        public CompositeTrustManagerFactory build() {
            return new CompositeTrustManagerFactory(this);
        }

        private static Optional<X509ExtendedTrustManager> toX509TrustManager(KeyStore keyStore) throws KeyStoreException {
            try {
                TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init(keyStore);
                return Arrays.stream(factory.getTrustManagers()).filter(tm -> tm instanceof X509ExtendedTrustManager).map(tm -> (X509ExtendedTrustManager)tm).findFirst();
            }
            catch (NoSuchAlgorithmException ex) {
                return Optional.empty();
            }
        }
    }
}

