/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.api;

import cdjd.com.dremio.telemetry.api.config.AutoRefreshConfigurator;
import cdjd.com.dremio.telemetry.api.config.ConfigModule;
import cdjd.com.dremio.telemetry.api.config.MetricsConfigurator;
import cdjd.com.dremio.telemetry.api.config.TelemetryConfigurator;
import cdjd.com.dremio.telemetry.api.config.TracerConfigurator;
import cdjd.com.dremio.telemetry.api.metrics.Metrics;
import cdjd.com.dremio.telemetry.utils.TracerFacade;
import cdjd.com.fasterxml.jackson.databind.ObjectMapper;
import cdjd.com.fasterxml.jackson.databind.ObjectReader;
import cdjd.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import cdjd.com.google.common.collect.ImmutableCollection;
import cdjd.com.google.common.collect.ImmutableList;
import cdjd.com.google.common.io.Resources;
import cdjd.io.opentelemetry.api.common.AttributeKey;
import cdjd.io.opentracing.Tracer;
import cdjd.io.opentracing.noop.NoopTracerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Telemetry {
    private static final String CONFIG_FILE = "dremio-telemetry.yaml";
    private static final String CONFIG_FILE_PROPERTY = "dremio.telemetry.configfile";
    private static final Logger logger = LoggerFactory.getLogger(Telemetry.class);
    private static AutoRefreshConfigurator<InnerTelemetryConf> CONFIG_REFRESHER;
    private static InnerTelemetryConfigListener CONFIG_REFRESH_LISTENER;
    public static final AttributeKey<Boolean> FORCE_SAMPLING_ATTRIBUTE;

    public static void startTelemetry() {
        if (CONFIG_REFRESH_LISTENER != null) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        ImmutableList.Builder modulesBuilder = ImmutableList.builder();
        ServiceLoader.load(ConfigModule.class).forEach(modulesBuilder::add);
        ImmutableCollection modules = modulesBuilder.build();
        if (modules.isEmpty()) {
            logger.warn("Unable to discover any modules for telemetry config. Will not refresh config.");
            return;
        }
        mapper.registerModules(modules);
        final ObjectReader reader = mapper.readerFor(TelemetryConfigurator.class);
        Provider<AutoRefreshConfigurator.CompleteRefreshConfig<InnerTelemetryConf>> configurationProvider = new Provider<AutoRefreshConfigurator.CompleteRefreshConfig<InnerTelemetryConf>>(){
            private final ExceptionWatcher exceptionWatcher = new ExceptionWatcher(ex -> logger.warn("Failure reading telemetry configuration. Leaving telemetry as is.", (Throwable)ex));

            public AutoRefreshConfigurator.CompleteRefreshConfig<InnerTelemetryConf> get() {
                URL resource = null;
                AutoRefreshConfigurator.CompleteRefreshConfig<InnerTelemetryConf> ret = null;
                try {
                    File file;
                    String configFilePath = System.getProperty(Telemetry.CONFIG_FILE_PROPERTY);
                    if (configFilePath != null && !configFilePath.isEmpty() && (file = new File(configFilePath)).exists()) {
                        resource = file.toURI().toURL();
                    }
                    if (resource == null) {
                        resource = Resources.getResource(Telemetry.CONFIG_FILE);
                    }
                    TelemetryConfigurator fromConfig = (TelemetryConfigurator)reader.readValue(resource);
                    InnerTelemetryConf telemConf = new InnerTelemetryConf(fromConfig.getMetricsConfigs(), fromConfig.getTracerConfig());
                    ret = new AutoRefreshConfigurator.CompleteRefreshConfig<InnerTelemetryConf>(fromConfig.getRefreshConfig(), telemConf);
                    this.exceptionWatcher.reset();
                }
                catch (IOException | IllegalArgumentException ex) {
                    this.exceptionWatcher.notify(ex);
                }
                return ret;
            }
        };
        CONFIG_REFRESH_LISTENER = new InnerTelemetryConfigListener(TracerFacade.INSTANCE);
        CONFIG_REFRESHER = new AutoRefreshConfigurator<InnerTelemetryConf>(configurationProvider, CONFIG_REFRESH_LISTENER);
    }

    static {
        FORCE_SAMPLING_ATTRIBUTE = AttributeKey.booleanKey("dremio-sample");
    }

    static class InnerTelemetryConfigListener
    implements Consumer<InnerTelemetryConf> {
        private final AutoRefreshConfigurator.ValueChangeDetector<Collection<MetricsConfigurator>> rememberedMetrics = InnerTelemetryConfigListener.configChangeConsumer("metrics", Metrics::onChange);
        private final AutoRefreshConfigurator.ValueChangeDetector<TracerConfigurator> rememberedTracer = InnerTelemetryConfigListener.configChangeConsumer("tracer", tracerConf -> {
            Tracer newTracer = tracerConf == null ? NoopTracerFactory.create() : tracerConf.getTracer();
            tracerFacade.setTracer(newTracer);
        });

        InnerTelemetryConfigListener(TracerFacade tracerFacade) {
        }

        private static <T> AutoRefreshConfigurator.ValueChangeDetector<T> configChangeConsumer(String type, Consumer<T> consumer) {
            return new AutoRefreshConfigurator.ValueChangeDetector<Object>(t -> {
                logger.debug("Updating {} configuration", (Object)type);
                consumer.accept(t);
                logger.debug("Updated {} configuration", (Object)type);
            });
        }

        @Override
        public synchronized void accept(InnerTelemetryConf update) {
            Collection<MetricsConfigurator> newMetrics = null;
            TracerConfigurator newTrace = null;
            if (update != null) {
                newMetrics = update.getMetricsConf();
                newTrace = update.getTracerConf();
            }
            this.rememberedMetrics.checkNewValue(newMetrics);
            this.rememberedTracer.checkNewValue(newTrace);
        }
    }

    private static class InnerTelemetryConf {
        private final Collection<MetricsConfigurator> metricsConf;
        private final TracerConfigurator tracerConf;

        InnerTelemetryConf(Collection<MetricsConfigurator> metricsConfigurators, TracerConfigurator tracerConf) {
            this.metricsConf = metricsConfigurators;
            this.tracerConf = tracerConf;
        }

        public Collection<MetricsConfigurator> getMetricsConf() {
            return this.metricsConf;
        }

        public TracerConfigurator getTracerConf() {
            return this.tracerConf;
        }
    }

    static class ExceptionWatcher {
        private final Consumer<Exception> consumer;
        private String lastExceptionMessage;

        ExceptionWatcher(Consumer<Exception> exceptionConsumer) {
            this.consumer = exceptionConsumer;
        }

        void reset() {
            this.lastExceptionMessage = "";
        }

        void notify(Exception ex) {
            if (!ex.getMessage().equals(this.lastExceptionMessage)) {
                this.lastExceptionMessage = ex.getMessage();
                this.consumer.accept(ex);
            }
        }
    }
}

