/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.api.metrics;

import cdjd.com.codahale.metrics.Metric;
import cdjd.com.codahale.metrics.MetricRegistry;
import cdjd.com.codahale.metrics.MetricSet;
import cdjd.com.codahale.metrics.Timer;
import cdjd.com.codahale.metrics.jetty9.InstrumentedHttpChannelListener;
import cdjd.com.codahale.metrics.jetty9.InstrumentedQueuedThreadPool;
import cdjd.com.codahale.metrics.jvm.BufferPoolMetricSet;
import cdjd.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import cdjd.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import cdjd.com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import cdjd.com.dremio.telemetry.api.config.MetricsConfigurator;
import cdjd.com.dremio.telemetry.api.metrics.CacheMonitor;
import cdjd.com.dremio.telemetry.api.metrics.Counter;
import cdjd.com.dremio.telemetry.api.metrics.Histogram;
import cdjd.com.dremio.telemetry.api.metrics.Meter;
import cdjd.com.dremio.telemetry.api.metrics.ReporterManager;
import cdjd.com.dremio.telemetry.api.metrics.Timer;
import cdjd.com.dremio.telemetry.api.metrics.TopMonitor;
import cdjd.com.github.rollingmetrics.counter.ResetOnSnapshotCounter;
import cdjd.com.github.rollingmetrics.counter.ResetPeriodicallyCounter;
import cdjd.com.github.rollingmetrics.counter.SmoothlyDecayingRollingCounter;
import cdjd.com.github.rollingmetrics.counter.WindowCounter;
import cdjd.com.github.rollingmetrics.histogram.HdrBuilder;
import cdjd.com.github.rollingmetrics.hitratio.HitRatio;
import cdjd.com.github.rollingmetrics.hitratio.ResetOnSnapshotHitRatio;
import cdjd.com.github.rollingmetrics.hitratio.ResetPeriodicallyHitRatio;
import cdjd.com.github.rollingmetrics.hitratio.SmoothlyDecayingRollingHitRatio;
import cdjd.com.github.rollingmetrics.hitratio.UniformHitRatio;
import cdjd.com.github.rollingmetrics.top.Top;
import cdjd.com.github.rollingmetrics.top.TopBuilder;
import cdjd.com.github.rollingmetrics.top.TopMetricSet;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.com.google.common.base.Joiner;
import cdjd.com.google.common.collect.ImmutableMap;
import cdjd.io.prometheus.client.Collector;
import cdjd.io.prometheus.client.CollectorRegistry;
import cdjd.io.prometheus.client.dropwizard.DropwizardExports;
import cdjd.io.prometheus.client.exporter.MetricsServlet;
import cdjd.io.prometheus.client.hotspot.StandardExports;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Metrics {
    private static final Logger logger = LoggerFactory.getLogger(Metrics.class);
    private static final int DECAY_CHUNKS = 10;

    private static synchronized void remove(String name) {
        if (RegistryHolder.REGISTRY.remove(name)) {
            logger.warn("Removing old metric since name matched newly registered metric. Metric name: {}", (Object)name);
        }
    }

    private static MetricSet scoped(final String name, final MetricSet metricSet) {
        return new MetricSet(){

            @Override
            public Map<String, Metric> getMetrics() {
                ImmutableMap.Builder<String, Metric> scopedMetrics = ImmutableMap.builder();
                for (Map.Entry<String, Metric> entry : metricSet.getMetrics().entrySet()) {
                    scopedMetrics.put(MetricRegistry.name(name, entry.getKey()), entry.getValue());
                }
                return scopedMetrics.build();
            }
        };
    }

    public static void onChange(Collection<MetricsConfigurator> updated) {
        RegistryHolder.REPORTERS.onChange(updated);
    }

    public static void resetMetrics() {
        RegistryHolder.REGISTRY.removeMatching((a, b) -> true);
        RegistryHolder.registerSysStats();
    }

    public static synchronized void unregister(String metric) {
        if (!RegistryHolder.REGISTRY.remove(metric)) {
            logger.warn("Could not find metric to unregister. Metric name: {}", (Object)metric);
        }
    }

    @VisibleForTesting
    public static Collection<MetricsConfigurator> getConfigurators() {
        return RegistryHolder.REPORTERS.getParentConfigurators();
    }

    public static synchronized void newGauge(String name, LongSupplier supplier) {
        Metrics.remove(name);
        RegistryHolder.REGISTRY.register(name, supplier::getAsLong);
    }

    public static synchronized Counter newCounter(String name, ResetType reset) {
        Metrics.remove(name);
        switch (reset) {
            case NEVER: {
                final cdjd.com.codahale.metrics.Counter inner = RegistryHolder.REGISTRY.counter(name);
                return new Counter(){

                    @Override
                    public void increment(long value, String ... tags) {
                        inner.inc(value);
                    }

                    @Override
                    public void decrement(long value, String ... tags) {
                        inner.dec(value);
                    }
                };
            }
            case ON_SNAPSHOT: {
                return Metrics.registerWindowCounter(name, new ResetOnSnapshotCounter());
            }
            case PERIODIC_15M: 
            case PERIODIC_1D: 
            case PERIODIC_7D: {
                return Metrics.registerWindowCounter(name, new ResetPeriodicallyCounter(reset.getDuration()));
            }
            case PERIODIC_DECAY: {
                return Metrics.registerWindowCounter(name, new SmoothlyDecayingRollingCounter(reset.getDuration(), 10));
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)reset));
    }

    private static Counter registerWindowCounter(String name, final WindowCounter counter) {
        RegistryHolder.REGISTRY.register(name, counter::getSum);
        return new Counter(){

            @Override
            public void increment(long value, String ... tags) {
                counter.add(value);
            }

            @Override
            public void decrement(long value, String ... tags) {
                counter.add(-value);
            }
        };
    }

    public static synchronized TopMonitor newTopReporter(String name, int count, Duration latencyThreshold, ResetType reset) {
        TopBuilder builder = Top.builder(count).withLatencyThreshold(latencyThreshold);
        switch (reset) {
            case NEVER: {
                builder.neverResetPositions();
                break;
            }
            case ON_SNAPSHOT: {
                builder.resetAllPositionsOnSnapshot();
                break;
            }
            case PERIODIC_15M: 
            case PERIODIC_1D: 
            case PERIODIC_7D: {
                builder.resetAllPositionsPeriodically(reset.getDuration());
                break;
            }
            case PERIODIC_DECAY: {
                builder.resetPositionsPeriodicallyByChunks(reset.getDuration(), 10);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)reset));
            }
        }
        Top top = builder.build();
        TopMetricSet metricSet = new TopMetricSet(name, top, TimeUnit.MILLISECONDS, 2);
        RegistryHolder.REGISTRY.registerAll(metricSet);
        return (latency, desc, tags) -> top.update(System.currentTimeMillis(), latency, TimeUnit.MILLISECONDS, () -> Metrics.lambda$newTopReporter$1((Supplier)desc));
    }

    public static synchronized Meter newMeter(String name) {
        Metrics.remove(name);
        cdjd.com.codahale.metrics.Meter meter = RegistryHolder.REGISTRY.meter(name);
        return tags -> meter.mark();
    }

    public static synchronized Histogram newHistogram(String name, ResetType reset) {
        Metrics.remove(name);
        HdrBuilder builder = new HdrBuilder();
        switch (reset) {
            case NEVER: {
                cdjd.com.codahale.metrics.Histogram histogram = RegistryHolder.REGISTRY.histogram(name);
                return (v, tags) -> histogram.update(v);
            }
            case ON_SNAPSHOT: {
                builder.resetReservoirOnSnapshot();
                break;
            }
            case PERIODIC_15M: 
            case PERIODIC_1D: 
            case PERIODIC_7D: {
                builder.resetReservoirPeriodically(reset.getDuration());
                break;
            }
            case PERIODIC_DECAY: {
                builder.resetReservoirPeriodicallyByChunks(reset.getDuration(), 10);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)reset));
            }
        }
        cdjd.com.codahale.metrics.Histogram hist = builder.buildAndRegisterHistogram(RegistryHolder.REGISTRY, name);
        return (v, tags) -> hist.update(v);
    }

    public static synchronized Timer newTimer(String name, ResetType reset) {
        Metrics.remove(name);
        HdrBuilder builder = new HdrBuilder();
        switch (reset) {
            case NEVER: {
                return Metrics.asPublicTimer(RegistryHolder.REGISTRY.timer(name));
            }
            case ON_SNAPSHOT: {
                builder.resetReservoirOnSnapshot();
                break;
            }
            case PERIODIC_15M: 
            case PERIODIC_1D: 
            case PERIODIC_7D: {
                builder.resetReservoirPeriodically(reset.getDuration());
                break;
            }
            case PERIODIC_DECAY: {
                builder.resetReservoirPeriodicallyByChunks(reset.getDuration(), 10);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)reset));
            }
        }
        return Metrics.asPublicTimer(builder.buildAndRegisterTimer(RegistryHolder.REGISTRY, name));
    }

    private static Timer asPublicTimer(final cdjd.com.codahale.metrics.Timer timer) {
        return new Timer(){

            @Override
            public Timer.TimerContext start(String ... tags) {
                Timer.Context ctxt = timer.time();
                return () -> ctxt.close();
            }

            @Override
            public void update(long duration, TimeUnit timeUnit) {
                timer.update(duration, timeUnit);
            }
        };
    }

    public static synchronized CacheMonitor newCacheMonitor(String name, ResetType reset) {
        HitRatio ratio;
        Metrics.remove(name);
        switch (reset) {
            case NEVER: {
                ratio = new UniformHitRatio();
                break;
            }
            case ON_SNAPSHOT: {
                ratio = new ResetOnSnapshotHitRatio();
                break;
            }
            case PERIODIC_15M: 
            case PERIODIC_1D: 
            case PERIODIC_7D: {
                ratio = new ResetPeriodicallyHitRatio(reset.getDuration());
                break;
            }
            case PERIODIC_DECAY: {
                ratio = new SmoothlyDecayingRollingHitRatio(reset.getDuration(), 10);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)reset));
            }
        }
        return new CacheMonitor(){

            @Override
            public void miss(String ... tags) {
                ratio.incrementMissCount();
            }

            @Override
            public void hit(String ... tags) {
                ratio.incrementHitCount();
            }
        };
    }

    public static String join(String ... fields) {
        return Joiner.on('.').join(fields);
    }

    public static InstrumentedHttpChannelListener newInstrumentedListener(String prefix) {
        return new InstrumentedHttpChannelListener(RegistryHolder.REGISTRY, prefix);
    }

    public static InstrumentedQueuedThreadPool newInstrumentedThreadPool(String prefix) {
        InstrumentedQueuedThreadPool instrumentedQTP = new InstrumentedQueuedThreadPool(RegistryHolder.REGISTRY);
        instrumentedQTP.setPrefix(prefix);
        return instrumentedQTP;
    }

    private static /* synthetic */ String lambda$newTopReporter$1(Supplier desc) {
        return (String)desc.get();
    }

    public static class HistogramSumGeneratorFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            CharResponseWrapper wrapper = new CharResponseWrapper((HttpServletResponse)response);
            chain.doFilter(request, (ServletResponse)wrapper);
            PrintWriter responseWriter = response.getWriter();
            if (wrapper.getContentType().contains("text/plain")) {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new CharArrayReader(wrapper.writer.toCharArray()));
                boolean needsSum = false;
                String metricName = null;
                while ((line = bufferedReader.readLine()) != null) {
                    responseWriter.write(line);
                    responseWriter.write(10);
                    if (line.contains("# TYPE ")) {
                        needsSum = false;
                        if (line.endsWith("histogram") || line.endsWith("summary")) {
                            needsSum = true;
                            metricName = line.split(" ")[2];
                            continue;
                        }
                    }
                    if (!needsSum || !line.contains(metricName + "_count")) continue;
                    line = line.replaceAll(metricName + "_count(.*?) .*$", metricName + "_sum$1 0.0");
                    responseWriter.write(line);
                    responseWriter.write(10);
                    needsSum = false;
                }
                bufferedReader.close();
            }
        }

        public void destroy() {
        }
    }

    public static class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private CharArrayWriter writer = new CharArrayWriter();

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() {
            return new PrintWriter(this.writer);
        }

        public String toString() {
            return this.writer.toString();
        }
    }

    public static enum ResetType {
        NEVER,
        ON_SNAPSHOT,
        PERIODIC_15M(Duration.ofMinutes(15L)),
        PERIODIC_1D(Duration.ofDays(1L)),
        PERIODIC_7D(Duration.ofDays(7L)),
        MULTI(Duration.ofDays(7L)),
        PERIODIC_DECAY(Duration.ofDays(7L));

        private Duration duration;

        private ResetType() {
            this.duration = null;
        }

        private ResetType(Duration duration) {
            this.duration = duration;
        }

        public Duration getDuration() {
            return this.duration;
        }
    }

    public static class MetricServletFactory {
        public static Servlet createMetricsServlet() {
            CollectorRegistry registry = new CollectorRegistry();
            registry.register((Collector)new DropwizardExports(RegistryHolder.REGISTRY));
            registry.register((Collector)new StandardExports());
            return new MetricsServlet(registry);
        }
    }

    @VisibleForTesting
    public static class RegistryHolder {
        private static MetricRegistry REGISTRY;
        private static ReporterManager REPORTERS;

        @VisibleForTesting
        public static void initRegistry() {
            REGISTRY = new MetricRegistry();
            RegistryHolder.registerSysStats();
            REPORTERS = new ReporterManager(REGISTRY);
        }

        private static void registerSysStats() {
            REGISTRY.registerAll(Metrics.scoped("gc", new GarbageCollectorMetricSet()));
            REGISTRY.registerAll(Metrics.scoped("buffer-pool", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer())));
            REGISTRY.registerAll(Metrics.scoped("memory", new MemoryUsageGaugeSet()));
            REGISTRY.registerAll(Metrics.scoped("threads", new ThreadStatesGaugeSet()));
        }

        static {
            RegistryHolder.initRegistry();
        }
    }
}

