/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.api.tracing.http;

import cdjd.com.dremio.telemetry.api.Telemetry;
import cdjd.io.opentelemetry.api.GlobalOpenTelemetry;
import cdjd.io.opentelemetry.api.trace.Span;
import cdjd.io.opentelemetry.api.trace.SpanBuilder;
import cdjd.io.opentelemetry.api.trace.SpanKind;
import cdjd.io.opentelemetry.api.trace.Tracer;
import cdjd.io.opentelemetry.context.Scope;
import cdjd.io.opentelemetry.context.propagation.TextMapGetter;
import cdjd.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=3000)
public class ServerTracingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(ServerTracingFilter.class);
    private static Tracer tracer;
    public static final String TRACING_SCOPE_CONTEXT_PROPERTY = "tracing-scope";
    public static final String TRACING_SPAN_CONTEXT_PROPERTY = "tracing-span";
    @Context
    private ResourceInfo resourceInfo;
    private final boolean checkForParentContextEnabled;
    private final String forcedSamplingHeader;

    public ServerTracingFilter() {
        this(false);
    }

    public ServerTracingFilter(boolean checkForParentSpansEnabled) {
        this(checkForParentSpansEnabled, null);
    }

    public ServerTracingFilter(boolean checkForParentSpansEnabled, String forceSamplingHeader) {
        this.checkForParentContextEnabled = checkForParentSpansEnabled;
        this.forcedSamplingHeader = forceSamplingHeader;
    }

    public boolean isCheckForParentContextEnabled() {
        return this.checkForParentContextEnabled;
    }

    private static Tracer getTracer() {
        if (tracer == null) {
            tracer = GlobalOpenTelemetry.getTracer("cdjd.com.dremio.server.http");
        }
        return tracer;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String spanName = this.resourceInfo != null ? this.resourceInfo.getResourceClass().getName() + "." + this.resourceInfo.getResourceMethod().getName() : "http-request";
        SpanBuilder spanBuilder = ServerTracingFilter.getTracer().spanBuilder(requestContext.getMethod() + " " + spanName);
        spanBuilder.setSpanKind(SpanKind.SERVER);
        spanBuilder.setAttribute(SemanticAttributes.HTTP_METHOD, requestContext.getMethod());
        spanBuilder.setAttribute(SemanticAttributes.HTTP_URL, requestContext.getUriInfo().getRequestUri().toASCIIString());
        MultivaluedMap pathParams = requestContext.getUriInfo().getPathParameters();
        if (!pathParams.isEmpty()) {
            pathParams.forEach((key, value) -> spanBuilder.setAttribute((String)key, String.join((CharSequence)",", value)));
        }
        if (this.forcedSamplingHeader != null && requestContext.getHeaders().containsKey((Object)this.forcedSamplingHeader)) {
            logger.debug("Found Header in request - '%s' : '%s'", (Object)this.forcedSamplingHeader, requestContext.getHeaders().getFirst((Object)this.forcedSamplingHeader));
            boolean headerValue = Boolean.parseBoolean("" + (String)requestContext.getHeaders().getFirst((Object)this.forcedSamplingHeader));
            if (headerValue) {
                spanBuilder.setAttribute(Telemetry.FORCE_SAMPLING_ATTRIBUTE, Boolean.valueOf(true));
            }
        }
        if (this.isCheckForParentContextEnabled()) {
            cdjd.io.opentelemetry.context.Context parentContext = this.extractParentContext(requestContext);
            spanBuilder.setParent(parentContext);
        }
        Span span = spanBuilder.startSpan();
        requestContext.setProperty(TRACING_SPAN_CONTEXT_PROPERTY, (Object)span);
        requestContext.setProperty(TRACING_SCOPE_CONTEXT_PROPERTY, (Object)span.makeCurrent());
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        int responseStatus = responseContext.getStatus();
        Scope scope = (Scope)requestContext.getProperty(TRACING_SCOPE_CONTEXT_PROPERTY);
        Span span = (Span)requestContext.getProperty(TRACING_SPAN_CONTEXT_PROPERTY);
        if (scope != null) {
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, responseStatus);
            span.end();
            scope.close();
        }
    }

    private cdjd.io.opentelemetry.context.Context extractParentContext(ContainerRequestContext requestContext) {
        TextMapGetter<ContainerRequestContext> getter = new TextMapGetter<ContainerRequestContext>(){

            @Override
            public Iterable<String> keys(ContainerRequestContext carrier) {
                return carrier.getHeaders().keySet();
            }

            @Override
            @Nullable
            public String get(@Nullable ContainerRequestContext carrier, @Nonnull String key) {
                if (carrier != null) {
                    return carrier.getHeaderString(key);
                }
                return null;
            }
        };
        return GlobalOpenTelemetry.get().getPropagators().getTextMapPropagator().extract(cdjd.io.opentelemetry.context.Context.current(), requestContext, getter);
    }
}

