/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.utils;

import cdjd.com.google.errorprone.annotations.MustBeClosed;
import cdjd.io.opencensus.trace.AttributeValue;
import cdjd.io.opencensus.trace.BlankSpan;
import cdjd.io.opencensus.trace.SpanBuilder;
import cdjd.io.opencensus.trace.SpanContext;
import cdjd.io.opencensus.trace.Tracer;
import cdjd.io.opencensus.trace.Tracing;
import cdjd.io.opencensus.trace.propagation.SpanContextParseException;
import cdjd.io.opencensus.trace.propagation.TextFormat;
import cdjd.io.opencensus.trace.samplers.Samplers;
import cdjd.io.opentracing.Scope;
import cdjd.io.opentracing.ScopeManager;
import cdjd.io.opentracing.Span;
import cdjd.io.opentracing.Tracer;
import cdjd.io.opentracing.noop.NoopSpan;
import cdjd.io.opentracing.propagation.Format;
import cdjd.io.opentracing.propagation.TextMapExtract;
import cdjd.io.opentracing.propagation.TextMapInject;
import cdjd.io.opentracing.tag.Tag;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class OpenCensusTracerAdapter
implements cdjd.io.opentracing.Tracer {
    private final Tracer ocTracer;

    public OpenCensusTracerAdapter(Tracer ocTracer) {
        this.ocTracer = ocTracer;
    }

    @Override
    public ScopeManager scopeManager() {
        throw new UnsupportedOperationException("Adapter does not support scopeManager");
    }

    @Override
    public Span activeSpan() {
        cdjd.io.opencensus.trace.Span inner = this.ocTracer.getCurrentSpan();
        if (inner == null) {
            return null;
        }
        boolean shouldNotSample = !inner.getContext().getTraceOptions().isSampled();
        return shouldNotSample ? NoopSpan.INSTANCE : new OpenCensusSpanAdapter(inner);
    }

    @Override
    @MustBeClosed
    public Scope activateSpan(Span span) {
        BlankSpan newSpan;
        if (span instanceof OpenCensusSpanAdapter) {
            OpenCensusSpanAdapter realSpan = (OpenCensusSpanAdapter)span;
            newSpan = realSpan.getOCSpan();
        } else {
            newSpan = BlankSpan.INSTANCE;
        }
        return new OpenCensusScopeAdapter(this.ocTracer.withSpan((cdjd.io.opencensus.trace.Span)newSpan));
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String opName) {
        return new OpenCensusSpanBuilderAdapter(this.ocTracer, opName);
    }

    @Override
    public <C> void inject(cdjd.io.opentracing.SpanContext context, Format<C> format, C carrier) {
        OpenCensusContextAdapter adapter = (OpenCensusContextAdapter)context;
        if (adapter == null) {
            return;
        }
        if (!(carrier instanceof TextMapInject)) {
            throw new UnsupportedOperationException(String.format("Injection format %s not supported", format));
        }
        TextMapInject map = (TextMapInject)carrier;
        TextFormat.Setter<TextMapInject> setter = new TextFormat.Setter<TextMapInject>(){

            public void put(TextMapInject carrier, String key, String value) {
                carrier.put(key, value);
            }
        };
        Tracing.getPropagationComponent().getB3Format().inject(adapter.getOcContext(), (Object)map, (TextFormat.Setter)setter);
    }

    @Override
    public <C> cdjd.io.opentracing.SpanContext extract(Format<C> format, C carrier) {
        if (!(carrier instanceof TextMapExtract)) {
            throw new UnsupportedOperationException(String.format("Extraction format %s not supported", format));
        }
        TextMapExtract textMap = (TextMapExtract)carrier;
        HashMap map = new HashMap();
        textMap.forEach(entry -> map.put((String)entry.getKey(), (String)entry.getValue()));
        TextFormat.Getter<Map<String, String>> getter = new TextFormat.Getter<Map<String, String>>(){

            @Nullable
            public String get(Map<String, String> carrier, String key) {
                return carrier.getOrDefault(key, null);
            }
        };
        try {
            return new OpenCensusContextAdapter(Tracing.getPropagationComponent().getB3Format().extract(map, (TextFormat.Getter)getter));
        }
        catch (SpanContextParseException e) {
            return NoopSpan.INSTANCE.context();
        }
    }

    @Override
    public void close() {
    }

    public static class OpenCensusSpanBuilderAdapter
    implements Tracer.SpanBuilder {
        private final Tracer tracer;
        private String opName;
        private SpanContext parentContext;
        private cdjd.io.opencensus.trace.Span parentSpan;
        private boolean ignoreActiveSpan = false;
        private Map<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();

        OpenCensusSpanBuilderAdapter(Tracer tracer, String opName) {
            this.tracer = tracer;
            this.opName = opName;
        }

        @Override
        public Tracer.SpanBuilder asChildOf(cdjd.io.opentracing.SpanContext parent) {
            if (!(parent instanceof OpenCensusContextAdapter)) {
                return this;
            }
            OpenCensusContextAdapter real = (OpenCensusContextAdapter)parent;
            this.ignoreActiveSpan = true;
            this.parentContext = real.getOcContext();
            return this;
        }

        @Override
        public Tracer.SpanBuilder asChildOf(Span parent) {
            if (!(parent instanceof OpenCensusSpanAdapter)) {
                return this;
            }
            this.ignoreActiveSpan = true;
            this.parentSpan = ((OpenCensusSpanAdapter)parent).getOCSpan();
            return this;
        }

        @Override
        public Tracer.SpanBuilder addReference(String referenceType, cdjd.io.opentracing.SpanContext referencedContext) {
            throw new UnsupportedOperationException("Adapter does not support references");
        }

        @Override
        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.ignoreActiveSpan = true;
            return this;
        }

        private Tracer.SpanBuilder addAttribute(String key, AttributeValue value) {
            this.attributes.put(key, value);
            return this;
        }

        @Override
        public Tracer.SpanBuilder withTag(String key, String value) {
            return this.addAttribute(key, AttributeValue.stringAttributeValue((String)value));
        }

        @Override
        public Tracer.SpanBuilder withTag(String key, boolean value) {
            return this.addAttribute(key, AttributeValue.booleanAttributeValue((boolean)value));
        }

        @Override
        public Tracer.SpanBuilder withTag(String key, Number value) {
            return this.addAttribute(key, AttributeValue.longAttributeValue((long)value.longValue()));
        }

        @Override
        public <T> Tracer.SpanBuilder withTag(Tag<T> key, T value) {
            throw new UnsupportedOperationException("Adapter does not support generic tags");
        }

        @Override
        public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
            throw new UnsupportedOperationException("Adapter does not support custom time");
        }

        @Override
        public Span start() {
            SpanBuilder sb = this.ignoreActiveSpan ? (this.parentSpan != null ? this.tracer.spanBuilderWithExplicitParent(this.opName, this.parentSpan) : (this.parentContext != null ? this.tracer.spanBuilderWithRemoteParent(this.opName, this.parentContext) : this.tracer.spanBuilderWithRemoteParent(this.opName, SpanContext.INVALID))) : this.tracer.spanBuilder(this.opName);
            sb.setSampler(Samplers.alwaysSample());
            cdjd.io.opencensus.trace.Span span = sb.startSpan();
            span.putAttributes(this.attributes);
            return new OpenCensusSpanAdapter(span);
        }
    }

    public static class OpenCensusScopeAdapter
    implements Scope {
        private final cdjd.io.opencensus.common.Scope ocScope;

        OpenCensusScopeAdapter(cdjd.io.opencensus.common.Scope ocScope) {
            this.ocScope = ocScope;
        }

        @Override
        public void close() {
            this.ocScope.close();
        }
    }

    public static class OpenCensusContextAdapter
    implements cdjd.io.opentracing.SpanContext {
        private final SpanContext ocContext;

        OpenCensusContextAdapter(SpanContext ocContext) {
            this.ocContext = ocContext;
        }

        SpanContext getOcContext() {
            return this.ocContext;
        }

        @Override
        public String toTraceId() {
            return this.ocContext.getTraceId().toString();
        }

        @Override
        public String toSpanId() {
            return this.ocContext.getSpanId().toString();
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            throw new UnsupportedOperationException("No baggage items for open census");
        }
    }

    public static class OpenCensusSpanAdapter
    implements Span {
        private final cdjd.io.opencensus.trace.Span ocSpan;

        OpenCensusSpanAdapter(cdjd.io.opencensus.trace.Span span) {
            this.ocSpan = span;
        }

        cdjd.io.opencensus.trace.Span getOCSpan() {
            return this.ocSpan;
        }

        @Override
        public cdjd.io.opentracing.SpanContext context() {
            return new OpenCensusContextAdapter(this.ocSpan.getContext());
        }

        @Override
        public Span setTag(String key, String value) {
            this.ocSpan.putAttribute(key, AttributeValue.stringAttributeValue((String)value));
            return this;
        }

        @Override
        public Span setTag(String key, boolean bool) {
            this.ocSpan.putAttribute(key, AttributeValue.booleanAttributeValue((boolean)bool));
            return this;
        }

        @Override
        public Span setTag(String key, Number num) {
            this.ocSpan.putAttribute(key, AttributeValue.longAttributeValue((long)num.longValue()));
            return this;
        }

        @Override
        public <T> Span setTag(Tag<T> tag, T value) {
            throw new UnsupportedOperationException("Adapter span only supports boolean, number, and string tags");
        }

        @Override
        public Span log(Map<String, ?> fields) {
            throw new UnsupportedOperationException("Adapter span does not support log on maps");
        }

        @Override
        public Span log(long timestamp, Map<String, ?> events) {
            throw new UnsupportedOperationException("Adapter span does not support log on maps");
        }

        @Override
        public Span log(String event) {
            this.ocSpan.addAnnotation(event);
            return this;
        }

        @Override
        public Span log(long ts, String event) {
            throw new UnsupportedOperationException("Adapter span does not support custom timestamp logs");
        }

        @Override
        public Span setBaggageItem(String key, String value) {
            throw new UnsupportedOperationException("Adapter span does not support baggage");
        }

        @Override
        public String getBaggageItem(String key) {
            throw new UnsupportedOperationException("Adapter span does not support baggage");
        }

        @Override
        public Span setOperationName(String name) {
            this.ocSpan.addAnnotation(name);
            return this;
        }

        @Override
        public void finish() {
            this.ocSpan.end();
        }

        @Override
        public void finish(long ts) {
            throw new UnsupportedOperationException("Adapter span does not support custom finish times");
        }
    }
}

