/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.dremio.telemetry.utils;

import cdjd.io.opentracing.Scope;
import cdjd.io.opentracing.ScopeManager;
import cdjd.io.opentracing.Span;
import cdjd.io.opentracing.SpanContext;
import cdjd.io.opentracing.Tracer;
import cdjd.io.opentracing.noop.NoopScopeManager;
import cdjd.io.opentracing.noop.NoopSpan;
import cdjd.io.opentracing.noop.NoopTracerFactory;
import cdjd.io.opentracing.propagation.Format;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TracerFacade
implements Tracer {
    public static final TracerFacade INSTANCE = new TracerFacade();
    private static final Logger logger = LoggerFactory.getLogger(TracerFacade.class);
    private Tracer tracer = NoopTracerFactory.create();

    private TracerFacade() {
    }

    public void setTracer(Tracer newTracer) {
        this.tracer = newTracer;
        logger.debug("Tracer updated");
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    @Override
    public ScopeManager scopeManager() {
        return this.tracer.scopeManager();
    }

    @Override
    public Span activeSpan() {
        return this.tracer.activeSpan();
    }

    @Override
    public Scope activateSpan(Span span) {
        if (span instanceof NoopSpan) {
            return NoopScopeManager.NoopScope.INSTANCE;
        }
        return this.tracer.activateSpan(span);
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String operationName) {
        return this.tracer.buildSpan(operationName);
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.tracer.inject(spanContext, format, carrier);
    }

    @Override
    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.tracer.extract(format, carrier);
    }

    @Override
    public void close() {
        this.tracer.close();
    }
}

