/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.fasterxml.jackson.databind.ext;

import cdjd.com.fasterxml.jackson.core.JsonGenerationException;
import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.com.fasterxml.jackson.databind.JavaType;
import cdjd.com.fasterxml.jackson.databind.JsonMappingException;
import cdjd.com.fasterxml.jackson.databind.JsonNode;
import cdjd.com.fasterxml.jackson.databind.SerializerProvider;
import cdjd.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import cdjd.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import cdjd.org.w3c.dom.Node;
import cdjd.org.w3c.dom.bootstrap.DOMImplementationRegistry;
import cdjd.org.w3c.dom.ls.DOMImplementationLS;
import cdjd.org.w3c.dom.ls.LSSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class DOMSerializer
extends StdSerializer<Node> {
    protected final DOMImplementationLS _domImpl;

    public DOMSerializer() {
        super(Node.class);
        DOMImplementationRegistry registry;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate DOMImplementationRegistry: " + e.getMessage(), e);
        }
        this._domImpl = (DOMImplementationLS)registry.getDOMImplementation("LS");
    }

    @Override
    public void serialize(Node value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._domImpl == null) {
            throw new IllegalStateException("Could not find DOM LS");
        }
        LSSerializer writer = this._domImpl.createLSSerializer();
        jgen.writeString(writer.writeToString(value));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectAnyFormat(typeHint);
        }
    }
}

