/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.github.rollingmetrics.histogram.accumulator;

import cdjd.com.codahale.metrics.Snapshot;
import cdjd.com.github.rollingmetrics.histogram.accumulator.Accumulator;
import cdjd.com.github.rollingmetrics.histogram.util.HistogramUtil;
import cdjd.com.github.rollingmetrics.histogram.util.Printer;
import cdjd.com.github.rollingmetrics.util.Clock;
import cdjd.com.github.rollingmetrics.util.ResilientExecutionUtil;
import cdjd.org.HdrHistogram.Histogram;
import cdjd.org.HdrHistogram.Recorder;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

public class ResetByChunksAccumulator
implements Accumulator {
    private final Executor backgroundExecutor;
    private final long intervalBetweenResettingMillis;
    private final long creationTimestamp;
    private final ArchivedHistogram[] archive;
    private final boolean historySupported;
    private final Clock clock;
    private final Histogram temporarySnapshotHistogram;
    private final Phase left;
    private final Phase right;
    private final Phase[] phases;
    private final AtomicReference<Phase> currentPhaseRef;

    public ResetByChunksAccumulator(Supplier<Recorder> recorderSupplier, int numberHistoryChunks, long intervalBetweenResettingMillis, Clock clock, Executor backgroundExecutor) {
        this.intervalBetweenResettingMillis = intervalBetweenResettingMillis;
        this.clock = clock;
        this.creationTimestamp = clock.currentTimeMillis();
        this.backgroundExecutor = backgroundExecutor;
        this.left = new Phase(recorderSupplier, this.creationTimestamp + intervalBetweenResettingMillis);
        this.right = new Phase(recorderSupplier, Long.MAX_VALUE);
        this.phases = new Phase[]{this.left, this.right};
        this.currentPhaseRef = new AtomicReference<Phase>(this.left);
        boolean bl = this.historySupported = numberHistoryChunks > 0;
        if (this.historySupported) {
            this.archive = new ArchivedHistogram[numberHistoryChunks];
            for (int i = 0; i < numberHistoryChunks; ++i) {
                Histogram archivedHistogram = HistogramUtil.createNonConcurrentCopy(this.left.intervalHistogram);
                this.archive[i] = new ArchivedHistogram(archivedHistogram, Long.MIN_VALUE);
            }
        } else {
            this.archive = null;
        }
        this.temporarySnapshotHistogram = HistogramUtil.createNonConcurrentCopy(this.left.intervalHistogram);
    }

    @Override
    public void recordSingleValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) {
        long currentTimeMillis = this.clock.currentTimeMillis();
        Phase currentPhase = this.currentPhaseRef.get();
        if (currentTimeMillis < currentPhase.proposedInvalidationTimestamp) {
            currentPhase.recorder.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
            return;
        }
        Phase nextPhase = currentPhase == this.left ? this.right : this.left;
        nextPhase.recorder.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
        if (!this.currentPhaseRef.compareAndSet(currentPhase, nextPhase)) {
            return;
        }
        Runnable phaseRotation = () -> this.rotate(currentTimeMillis, currentPhase, nextPhase);
        ResilientExecutionUtil.getInstance().execute(this.backgroundExecutor, phaseRotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rotate(long currentTimeMillis, Phase currentPhase, Phase nextPhase) {
        try {
            currentPhase.intervalHistogram = currentPhase.recorder.getIntervalHistogram(currentPhase.intervalHistogram);
            HistogramUtil.addSecondToFirst(currentPhase.totalsHistogram, currentPhase.intervalHistogram);
            if (this.historySupported) {
                long currentPhaseNumber = (currentPhase.proposedInvalidationTimestamp - this.creationTimestamp) / this.intervalBetweenResettingMillis;
                int correspondentArchiveIndex = (int)(currentPhaseNumber - 1L) % this.archive.length;
                ArchivedHistogram correspondentArchivedHistogram = this.archive[correspondentArchiveIndex];
                HistogramUtil.reset(correspondentArchivedHistogram.histogram);
                HistogramUtil.addSecondToFirst(correspondentArchivedHistogram.histogram, currentPhase.totalsHistogram);
                correspondentArchivedHistogram.proposedInvalidationTimestamp = currentPhase.proposedInvalidationTimestamp + (long)this.archive.length * this.intervalBetweenResettingMillis;
            }
            HistogramUtil.reset(currentPhase.totalsHistogram);
        }
        finally {
            long millisSinceCreation = currentTimeMillis - this.creationTimestamp;
            long intervalsSinceCreation = millisSinceCreation / this.intervalBetweenResettingMillis;
            currentPhase.proposedInvalidationTimestamp = Long.MAX_VALUE;
            nextPhase.proposedInvalidationTimestamp = this.creationTimestamp + (intervalsSinceCreation + 1L) * this.intervalBetweenResettingMillis;
        }
    }

    @Override
    public final synchronized Snapshot getSnapshot(Function<Histogram, Snapshot> snapshotTaker) {
        HistogramUtil.reset(this.temporarySnapshotHistogram);
        long currentTimeMillis = this.clock.currentTimeMillis();
        for (Phase phase : this.phases) {
            if (!phase.isNeedToBeReportedToSnapshot(currentTimeMillis)) continue;
            phase.intervalHistogram = phase.recorder.getIntervalHistogram(phase.intervalHistogram);
            HistogramUtil.addSecondToFirst(phase.totalsHistogram, phase.intervalHistogram);
            HistogramUtil.addSecondToFirst(this.temporarySnapshotHistogram, phase.totalsHistogram);
        }
        if (this.historySupported) {
            for (ArchivedHistogram archivedHistogram : this.archive) {
                if (archivedHistogram.proposedInvalidationTimestamp <= currentTimeMillis) continue;
                HistogramUtil.addSecondToFirst(this.temporarySnapshotHistogram, archivedHistogram.histogram);
            }
        }
        return HistogramUtil.getSnapshot(this.temporarySnapshotHistogram, snapshotTaker);
    }

    @Override
    public int getEstimatedFootprintInBytes() {
        int oneHistogramPessimisticFootprint = this.temporarySnapshotHistogram.getEstimatedFootprintInBytes();
        return oneHistogramPessimisticFootprint * ((this.archive != null ? this.archive.length : 0) + 4 + 2 + 1);
    }

    public String toString() {
        return "ResetByChunksAccumulator{\nintervalBetweenResettingMillis=" + this.intervalBetweenResettingMillis + ",\n creationTimestamp=" + this.creationTimestamp + (!this.historySupported ? "" : ",\n archive=" + Printer.printArray(this.archive, "chunk")) + ",\n clock=" + this.clock + ",\n left=" + this.left + ",\n right=" + this.right + ",\n currentPhase=" + (this.currentPhaseRef.get() == this.left ? "left" : "right") + ",\n temporarySnapshotHistogram=" + Printer.histogramToString(this.temporarySnapshotHistogram) + '}';
    }

    private final class Phase {
        final Recorder recorder;
        final Histogram totalsHistogram;
        Histogram intervalHistogram;
        volatile long proposedInvalidationTimestamp;

        Phase(Supplier<Recorder> recorderSupplier, long proposedInvalidationTimestamp) {
            this.recorder = recorderSupplier.get();
            this.intervalHistogram = this.recorder.getIntervalHistogram();
            this.totalsHistogram = this.intervalHistogram.copy();
            this.proposedInvalidationTimestamp = proposedInvalidationTimestamp;
        }

        public String toString() {
            return "Phase{\n, proposedInvalidationTimestamp=" + this.proposedInvalidationTimestamp + "\n, totalsHistogram=" + (this.totalsHistogram != null ? Printer.histogramToString(this.totalsHistogram) : "null") + "\n, intervalHistogram=" + Printer.histogramToString(this.intervalHistogram) + "\n}";
        }

        boolean isNeedToBeReportedToSnapshot(long currentTimeMillis) {
            long proposedInvalidationTimestampLocal = this.proposedInvalidationTimestamp;
            if (proposedInvalidationTimestampLocal > currentTimeMillis) {
                return true;
            }
            if (!ResetByChunksAccumulator.this.historySupported) {
                return false;
            }
            long correspondentChunkProposedInvalidationTimestamp = proposedInvalidationTimestampLocal + (long)ResetByChunksAccumulator.this.archive.length * ResetByChunksAccumulator.this.intervalBetweenResettingMillis;
            return correspondentChunkProposedInvalidationTimestamp > currentTimeMillis;
        }
    }

    private final class ArchivedHistogram {
        private final Histogram histogram;
        private volatile long proposedInvalidationTimestamp;

        public ArchivedHistogram(Histogram histogram, long proposedInvalidationTimestamp) {
            this.histogram = histogram;
            this.proposedInvalidationTimestamp = proposedInvalidationTimestamp;
        }

        public String toString() {
            return "ArchivedHistogram{\n, proposedInvalidationTimestamp=" + this.proposedInvalidationTimestamp + "\n, histogram=" + Printer.histogramToString(this.histogram) + "\n}";
        }
    }
}

