/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.github.rollingmetrics.top.impl;

import cdjd.com.github.rollingmetrics.top.Position;
import cdjd.com.github.rollingmetrics.top.Top;
import cdjd.com.github.rollingmetrics.top.impl.collector.PositionCollector;
import cdjd.com.github.rollingmetrics.top.impl.recorder.PositionRecorder;
import cdjd.com.github.rollingmetrics.top.impl.recorder.TwoPhasePositionRecorder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class UniformTop
implements Top {
    private final TwoPhasePositionRecorder phasedRecorder;
    private final PositionCollector uniformCollector;
    private PositionRecorder intervalRecorder;

    public UniformTop(int size, long latencyThresholdNanos, int maxDescriptionLength) {
        this.phasedRecorder = new TwoPhasePositionRecorder(size, latencyThresholdNanos, maxDescriptionLength);
        this.intervalRecorder = this.phasedRecorder.getIntervalRecorder();
        this.uniformCollector = PositionCollector.createCollector(size);
    }

    @Override
    public void update(long timestamp, long latencyTime, TimeUnit latencyUnit, Supplier<String> descriptionSupplier) {
        this.phasedRecorder.update(timestamp, latencyTime, latencyUnit, descriptionSupplier);
    }

    @Override
    public synchronized List<Position> getPositionsInDescendingOrder() {
        this.intervalRecorder = this.phasedRecorder.getIntervalRecorder(this.intervalRecorder);
        this.intervalRecorder.addInto(this.uniformCollector);
        return this.uniformCollector.getPositionsInDescendingOrder();
    }

    @Override
    public int getSize() {
        return this.intervalRecorder.getSize();
    }
}

