/*
 * Decompiled with CFR 0.152.
 */
package cdjd.com.google.common.io;

import cdjd.com.google.common.annotations.Beta;
import cdjd.com.google.common.annotations.GwtIncompatible;
import cdjd.com.google.common.base.Preconditions;
import cdjd.com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

