/*
 * Decompiled with CFR 0.152.
 */
package cdjd.io.netty.handler.ssl;

import cdjd.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import cdjd.io.netty.handler.ssl.OpenSslSessionContext;
import cdjd.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import cdjd.io.netty.internal.tcnative.SSL;
import cdjd.io.netty.internal.tcnative.SSLContext;
import java.util.concurrent.locks.Lock;

public final class OpenSslServerSessionContext
extends OpenSslSessionContext {
    OpenSslServerSessionContext(ReferenceCountedOpenSslContext context, OpenSslKeyMaterialProvider provider) {
        super(context, provider);
    }

    @Override
    public void setSessionTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            SSLContext.setSessionCacheTimeout(this.context.ctx, seconds);
        }
        finally {
            writerLock.unlock();
        }
    }

    @Override
    public int getSessionTimeout() {
        Lock readerLock = this.context.ctxLock.readLock();
        readerLock.lock();
        try {
            int n = (int)SSLContext.getSessionCacheTimeout(this.context.ctx);
            return n;
        }
        finally {
            readerLock.unlock();
        }
    }

    @Override
    public void setSessionCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            SSLContext.setSessionCacheSize(this.context.ctx, size);
        }
        finally {
            writerLock.unlock();
        }
    }

    @Override
    public int getSessionCacheSize() {
        Lock readerLock = this.context.ctxLock.readLock();
        readerLock.lock();
        try {
            int n = (int)SSLContext.getSessionCacheSize(this.context.ctx);
            return n;
        }
        finally {
            readerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionCacheEnabled(boolean enabled) {
        long mode = enabled ? SSL.SSL_SESS_CACHE_SERVER : SSL.SSL_SESS_CACHE_OFF;
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            SSLContext.setSessionCacheMode(this.context.ctx, mode);
        }
        finally {
            writerLock.unlock();
        }
    }

    @Override
    public boolean isSessionCacheEnabled() {
        Lock readerLock = this.context.ctxLock.readLock();
        readerLock.lock();
        try {
            boolean bl = SSLContext.getSessionCacheMode(this.context.ctx) == SSL.SSL_SESS_CACHE_SERVER;
            return bl;
        }
        finally {
            readerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSessionIdContext(byte[] sidCtx) {
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            boolean bl = SSLContext.setSessionIdContext(this.context.ctx, sidCtx);
            return bl;
        }
        finally {
            writerLock.unlock();
        }
    }
}

