/*
 * Decompiled with CFR 0.152.
 */
package cdjd.io.opentelemetry.api.trace;

import cdjd.io.opentelemetry.api.internal.OtelEncodingUtils;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SpanId {
    private static final ThreadLocal<char[]> charBuffer = new ThreadLocal();
    private static final int BYTES_LENGTH = 8;
    private static final int HEX_LENGTH = 16;
    private static final String INVALID = "0000000000000000";

    private SpanId() {
    }

    public static int getLength() {
        return 16;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence spanId) {
        return spanId != null && spanId.length() == 16 && !INVALID.contentEquals(spanId) && OtelEncodingUtils.isValidBase16String(spanId);
    }

    public static String fromBytes(byte[] spanIdBytes) {
        if (spanIdBytes == null || spanIdBytes.length < 8) {
            return INVALID;
        }
        char[] result = SpanId.getTemporaryBuffer();
        OtelEncodingUtils.bytesToBase16(spanIdBytes, result, 8);
        return new String(result);
    }

    public static String fromLong(long id) {
        if (id == 0L) {
            return SpanId.getInvalid();
        }
        char[] result = SpanId.getTemporaryBuffer();
        OtelEncodingUtils.longToBase16String(id, result, 0);
        return new String(result);
    }

    private static char[] getTemporaryBuffer() {
        char[] chars = charBuffer.get();
        if (chars == null) {
            chars = new char[16];
            charBuffer.set(chars);
        }
        return chars;
    }
}

