/*
 * Decompiled with CFR 0.152.
 */
package cdjd.io.opentelemetry.context;

import cdjd.com.google.errorprone.annotations.MustBeClosed;
import cdjd.io.opentelemetry.context.ArrayBasedContext;
import cdjd.io.opentelemetry.context.ContextExecutorService;
import cdjd.io.opentelemetry.context.ContextKey;
import cdjd.io.opentelemetry.context.ContextScheduledExecutorService;
import cdjd.io.opentelemetry.context.ContextStorage;
import cdjd.io.opentelemetry.context.ImplicitContextKeyed;
import cdjd.io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public interface Context {
    public static Context current() {
        Context current = ContextStorage.get().current();
        return current != null ? current : Context.root();
    }

    public static Context root() {
        return ArrayBasedContext.root();
    }

    @Nullable
    public <V> V get(ContextKey<V> var1);

    public <V> Context with(ContextKey<V> var1, V var2);

    default public Context with(ImplicitContextKeyed value) {
        return value.storeInContext(this);
    }

    @MustBeClosed
    default public Scope makeCurrent() {
        return ContextStorage.get().attach(this);
    }

    default public Runnable wrap(Runnable runnable) {
        return () -> {
            try (Scope ignored = this.makeCurrent();){
                runnable.run();
            }
        };
    }

    default public <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            try (Scope ignored = this.makeCurrent();){
                Object v = callable.call();
                return v;
            }
        };
    }

    default public Executor wrap(Executor executor) {
        return command -> executor.execute(this.wrap(command));
    }

    default public ExecutorService wrap(ExecutorService executor) {
        return new ContextExecutorService(this, executor);
    }

    default public ScheduledExecutorService wrap(ScheduledExecutorService executor) {
        return new ContextScheduledExecutorService(this, executor);
    }
}

