/*
 * Decompiled with CFR 0.152.
 */
package cdjd.net.logstash.logback.composite;

import cdjd.com.fasterxml.jackson.core.JsonFactory;
import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.net.logstash.logback.composite.JsonFactoryAware;
import cdjd.net.logstash.logback.composite.JsonProvider;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonProviders<Event extends DeferredProcessingAware>
implements JsonFactoryAware {
    private final List<JsonProvider<Event>> jsonProviders = new ArrayList<JsonProvider<Event>>();

    public void start() {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.start();
        }
    }

    public void stop() {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.stop();
        }
    }

    public void setContext(Context context) {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.setContext(context);
        }
    }

    public void addProvider(JsonProvider<Event> provider) {
        if (provider != null) {
            this.jsonProviders.add(provider);
        }
    }

    public void removeProvider(JsonProvider<Event> provider) {
        if (provider != null) {
            this.jsonProviders.remove(provider);
        }
    }

    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.writeTo(generator, event);
        }
    }

    protected void prepareForDeferredProcessing(Event event) {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.prepareForDeferredProcessing(event);
        }
    }

    @Override
    public void setJsonFactory(JsonFactory jsonFactory) {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            if (!(jsonProvider instanceof JsonFactoryAware)) continue;
            ((JsonFactoryAware)((Object)jsonProvider)).setJsonFactory(jsonFactory);
        }
    }

    public List<JsonProvider<Event>> getProviders() {
        return Collections.unmodifiableList(this.jsonProviders);
    }
}

