/*
 * Decompiled with CFR 0.152.
 */
package cdjd.net.logstash.logback.composite.loggingevent;

import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.net.logstash.logback.argument.StructuredArgument;
import cdjd.net.logstash.logback.composite.AbstractFieldJsonProvider;
import cdjd.net.logstash.logback.composite.FieldNamesAware;
import cdjd.net.logstash.logback.fieldnames.LogstashFieldNames;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.IOException;

public class ArgumentsJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    private boolean includeStructuredArguments = true;
    private boolean includeNonStructuredArguments;
    private String nonStructuredArgumentsFieldPrefix = "arg";

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        if (!this.includeStructuredArguments && !this.includeNonStructuredArguments) {
            return;
        }
        Object[] args = event.getArgumentArray();
        if (args == null || args.length == 0) {
            return;
        }
        boolean hasWrittenFieldName = false;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            Object arg = args[argIndex];
            if (arg instanceof StructuredArgument) {
                if (!this.includeStructuredArguments) continue;
                if (!hasWrittenFieldName && this.getFieldName() != null) {
                    generator.writeObjectFieldStart(this.getFieldName());
                    hasWrittenFieldName = true;
                }
                StructuredArgument structuredArgument = (StructuredArgument)arg;
                structuredArgument.writeTo(generator);
                continue;
            }
            if (!this.includeNonStructuredArguments) continue;
            if (!hasWrittenFieldName && this.getFieldName() != null) {
                generator.writeObjectFieldStart(this.getFieldName());
                hasWrittenFieldName = true;
            }
            String fieldName = this.nonStructuredArgumentsFieldPrefix + argIndex;
            generator.writeObjectField(fieldName, arg);
        }
        if (hasWrittenFieldName) {
            generator.writeEndObject();
        }
    }

    public boolean isIncludeStructuredArguments() {
        return this.includeStructuredArguments;
    }

    public void setIncludeStructuredArguments(boolean includeStructuredArguments) {
        this.includeStructuredArguments = includeStructuredArguments;
    }

    public boolean isIncludeNonStructuredArguments() {
        return this.includeNonStructuredArguments;
    }

    public void setIncludeNonStructuredArguments(boolean includeNonStructuredArguments) {
        this.includeNonStructuredArguments = includeNonStructuredArguments;
    }

    public String getNonStructuredArgumentsFieldPrefix() {
        return this.nonStructuredArgumentsFieldPrefix;
    }

    public void setNonStructuredArgumentsFieldPrefix(String nonStructuredArgumentsFieldPrefix) {
        this.nonStructuredArgumentsFieldPrefix = nonStructuredArgumentsFieldPrefix;
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getArguments());
    }
}

