/*
 * Decompiled with CFR 0.152.
 */
package cdjd.net.logstash.logback.composite.loggingevent;

import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.net.logstash.logback.CachingAbbreviator;
import cdjd.net.logstash.logback.NullAbbreviator;
import cdjd.net.logstash.logback.composite.AbstractFieldJsonProvider;
import cdjd.net.logstash.logback.composite.FieldNamesAware;
import cdjd.net.logstash.logback.composite.JsonWritingUtils;
import cdjd.net.logstash.logback.fieldnames.LogstashFieldNames;
import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.IOException;

public class LoggerNameJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_LOGGER_NAME = "logger_name";
    private int shortenedLoggerNameLength = -1;
    private Abbreviator abbreviator = NullAbbreviator.INSTANCE;

    public LoggerNameJsonProvider() {
        this.setFieldName(FIELD_LOGGER_NAME);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        JsonWritingUtils.writeStringField(generator, this.getFieldName(), this.abbreviator.abbreviate(event.getLoggerName()));
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getLogger());
    }

    public int getShortenedLoggerNameLength() {
        return this.shortenedLoggerNameLength;
    }

    public void setShortenedLoggerNameLength(int length) {
        this.shortenedLoggerNameLength = length;
        this.abbreviator = length >= 0 ? new CachingAbbreviator((Abbreviator)new TargetLengthBasedClassNameAbbreviator(this.shortenedLoggerNameLength)) : NullAbbreviator.INSTANCE;
    }
}

