/*
 * Decompiled with CFR 0.152.
 */
package cdjd.net.logstash.logback.composite.loggingevent;

import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.net.logstash.logback.composite.AbstractFieldJsonProvider;
import cdjd.net.logstash.logback.composite.FieldNamesAware;
import cdjd.net.logstash.logback.composite.JsonWritingUtils;
import cdjd.net.logstash.logback.fieldnames.LogstashFieldNames;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MdcJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    private List<String> includeMdcKeyNames = new ArrayList<String>();
    private List<String> excludeMdcKeyNames = new ArrayList<String>();

    @Override
    public void start() {
        if (!this.includeMdcKeyNames.isEmpty() && !this.excludeMdcKeyNames.isEmpty()) {
            this.addError("Both includeMdcKeyNames and excludeMdcKeyNames are not empty.  Only one is allowed to be not empty.");
        }
        super.start();
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        HashMap mdcProperties = event.getMDCPropertyMap();
        if (mdcProperties != null && !mdcProperties.isEmpty()) {
            if (this.getFieldName() != null) {
                generator.writeObjectFieldStart(this.getFieldName());
            }
            if (!this.includeMdcKeyNames.isEmpty()) {
                mdcProperties = new HashMap(mdcProperties);
                mdcProperties.keySet().retainAll(this.includeMdcKeyNames);
            }
            if (!this.excludeMdcKeyNames.isEmpty()) {
                mdcProperties = new HashMap(mdcProperties);
                mdcProperties.keySet().removeAll(this.excludeMdcKeyNames);
            }
            JsonWritingUtils.writeMapEntries(generator, mdcProperties);
            if (this.getFieldName() != null) {
                generator.writeEndObject();
            }
        }
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getMdc());
    }

    public List<String> getIncludeMdcKeyNames() {
        return Collections.unmodifiableList(this.includeMdcKeyNames);
    }

    public void addIncludeMdcKeyName(String includedMdcKeyName) {
        this.includeMdcKeyNames.add(includedMdcKeyName);
    }

    public void setIncludeMdcKeyNames(List<String> includeMdcKeyNames) {
        this.includeMdcKeyNames = new ArrayList<String>(includeMdcKeyNames);
    }

    public List<String> getExcludeMdcKeyNames() {
        return Collections.unmodifiableList(this.excludeMdcKeyNames);
    }

    public void addExcludeMdcKeyName(String excludedMdcKeyName) {
        this.excludeMdcKeyNames.add(excludedMdcKeyName);
    }

    public void setExcludeMdcKeyNames(List<String> excludeMdcKeyNames) {
        this.excludeMdcKeyNames = new ArrayList<String>(excludeMdcKeyNames);
    }
}

