/*
 * Decompiled with CFR 0.152.
 */
package cdjd.net.logstash.logback.decorate;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class FeatureDecorator<T, F extends Enum<F>> {
    private final Class<F> enumType;
    private final BiFunction<T, F, T> enableFunction;
    private final BiFunction<T, F, T> disableFunction;
    private final List<F> enables = new ArrayList<F>();
    private final List<F> disables = new ArrayList<F>();

    protected FeatureDecorator(Class<F> enumType, BiFunction<T, F, T> enableFunction, BiFunction<T, F, T> disableFunction) {
        this.enumType = enumType;
        this.enableFunction = enableFunction;
        this.disableFunction = disableFunction;
    }

    public T decorate(T target) {
        T modifiedTarget = target;
        for (Enum feature : this.enables) {
            modifiedTarget = this.enableFunction.apply(modifiedTarget, feature);
        }
        for (Enum feature : this.disables) {
            modifiedTarget = this.disableFunction.apply(modifiedTarget, feature);
        }
        return modifiedTarget;
    }

    public void addEnable(String feature) {
        this.enable(Enum.valueOf(this.enumType, feature));
    }

    public void enable(F feature) {
        this.enables.add(feature);
    }

    public void addDisable(String feature) {
        this.disable(Enum.valueOf(this.enumType, feature));
    }

    public void disable(F feature) {
        this.disables.add(feature);
    }
}

