/*
 * Decompiled with CFR 0.152.
 */
package cdjd.net.logstash.logback.marker;

import cdjd.com.fasterxml.jackson.core.JsonGenerator;
import cdjd.com.fasterxml.jackson.databind.JsonMappingException;
import cdjd.com.fasterxml.jackson.databind.JsonSerializer;
import cdjd.com.fasterxml.jackson.databind.ObjectMapper;
import cdjd.com.fasterxml.jackson.databind.SerializerProvider;
import cdjd.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import cdjd.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import cdjd.com.fasterxml.jackson.databind.util.NameTransformer;
import cdjd.net.logstash.logback.argument.StructuredArgument;
import cdjd.net.logstash.logback.argument.StructuredArguments;
import cdjd.net.logstash.logback.marker.LogstashMarker;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectFieldsAppendingMarker
extends LogstashMarker
implements StructuredArgument {
    public static final String MARKER_NAME = "LS_OBJECT_FIELDS";
    private final Object object;
    private static final ConcurrentHashMap<Class<?>, JsonSerializer<Object>> beanSerializers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<ObjectMapper, SerializerProvider> serializerProviders = new ConcurrentHashMap();

    public ObjectFieldsAppendingMarker(Object object) {
        super(MARKER_NAME);
        this.object = object;
    }

    @Override
    public void writeTo(JsonGenerator generator) throws IOException {
        ObjectMapper mapper;
        JsonSerializer<Object> serializer;
        if (this.object != null && (serializer = this.getBeanSerializer(mapper = (ObjectMapper)generator.getCodec())).isUnwrappingSerializer()) {
            serializer.serialize(this.object, generator, this.getSerializerProvider(mapper));
        }
    }

    @Override
    public String toStringSelf() {
        return StructuredArguments.toString(this.object);
    }

    private JsonSerializer<Object> getBeanSerializer(ObjectMapper mapper) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = beanSerializers.get(this.object.getClass());
        if (jsonSerializer == null) {
            JsonSerializer<Object> existingSerializer;
            SerializerProvider serializerProvider = this.getSerializerProvider(mapper);
            JsonSerializer<Object> newSerializer = mapper.getSerializerFactory().createSerializer(serializerProvider, mapper.getSerializationConfig().constructType(this.object.getClass())).unwrappingSerializer(NameTransformer.NOP);
            if (newSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)newSerializer)).resolve(serializerProvider);
            }
            jsonSerializer = (existingSerializer = beanSerializers.putIfAbsent(this.object.getClass(), newSerializer)) == null ? newSerializer : existingSerializer;
        }
        return jsonSerializer;
    }

    private SerializerProvider getSerializerProvider(ObjectMapper mapper) {
        SerializerProvider provider = serializerProviders.get(mapper);
        if (provider == null) {
            DefaultSerializerProvider newProvider = ((DefaultSerializerProvider)mapper.getSerializerProvider()).createInstance(mapper.getSerializationConfig(), mapper.getSerializerFactory());
            SerializerProvider existingProvider = serializerProviders.putIfAbsent(mapper, newProvider);
            provider = existingProvider == null ? newProvider : existingProvider;
        }
        return provider;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectFieldsAppendingMarker)) {
            return false;
        }
        ObjectFieldsAppendingMarker other = (ObjectFieldsAppendingMarker)obj;
        return Objects.equals(this.object, other.object);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }
}

