/*
 * Decompiled with CFR 0.152.
 */
package cdjd.net.logstash.logback.stacktrace;

import java.util.List;
import java.util.regex.Pattern;

public abstract class StackElementFilter {
    public abstract boolean accept(StackTraceElement var1);

    public static final StackElementFilter any() {
        return new StackElementFilter(){

            @Override
            public boolean accept(StackTraceElement element) {
                return true;
            }
        };
    }

    public static final StackElementFilter withSourceInfo() {
        return new StackElementFilter(){

            @Override
            public boolean accept(StackTraceElement element) {
                return element.getFileName() != null && element.getLineNumber() >= 0;
            }
        };
    }

    public static final StackElementFilter byPattern(final List<Pattern> excludes) {
        return new StackElementFilter(){

            @Override
            public boolean accept(StackTraceElement element) {
                if (!excludes.isEmpty()) {
                    String classNameAndMethod = element.getClassName() + "." + element.getMethodName();
                    for (Pattern exclusionPattern : excludes) {
                        if (!exclusionPattern.matcher(classNameAndMethod).find()) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }
}

