/*
 * Decompiled with CFR 0.152.
 */
package cdjd.net.logstash.logback.status;

import cdjd.net.logstash.logback.status.DelegatingStatusListener;
import ch.qos.logback.core.status.OnPrintStreamStatusListenerBase;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;

public class LevelFilteringStatusListener
extends DelegatingStatusListener {
    private int statusLevel = 0;

    @Override
    public void addStatusEvent(Status status) {
        if (status.getEffectiveLevel() >= this.statusLevel) {
            super.addStatusEvent(status);
        }
    }

    public void setLevel(String level) {
        if (level.trim().equalsIgnoreCase("INFO")) {
            this.statusLevel = 0;
        } else if (level.trim().equalsIgnoreCase("WARN")) {
            this.statusLevel = 1;
        } else if (level.trim().equalsIgnoreCase("ERROR")) {
            this.statusLevel = 2;
        } else {
            throw new IllegalArgumentException(String.format("Unknown level: %s. Must be one of INFO, WARN, or ERROR.", level));
        }
    }

    public int getLevelValue() {
        return this.statusLevel;
    }

    public void setLevelValue(int levelValue) {
        if (levelValue < 0 || levelValue > 2) {
            throw new IllegalArgumentException(String.format("Unknown level: %d. Must be between %d and %d, inclusive", 0, 2));
        }
        this.statusLevel = levelValue;
    }

    @Override
    public void setDelegate(StatusListener delegate) {
        super.setDelegate(delegate);
        if (delegate instanceof OnPrintStreamStatusListenerBase) {
            ((OnPrintStreamStatusListenerBase)delegate).setRetrospective(0L);
        }
    }
}

