/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.memory;

import cdjd.com.dremio.common.VM;
import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.common.memory.DremioRootAllocator;
import cdjd.com.dremio.config.DremioConfig;
import cdjd.com.google.common.annotations.VisibleForTesting;
import cdjd.io.netty.buffer.PooledByteBufAllocator;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RootAllocatorFactory {
    private static final String IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY = "cdjd.io.netty.allocator.useCacheForAllThreads";
    private static final Logger LOGGER = LoggerFactory.getLogger(RootAllocatorFactory.class);
    public static final String TOP_LEVEL_MAX_ALLOC = "dremio.memory.top.max";

    private RootAllocatorFactory() {
    }

    @VisibleForTesting
    public static BufferAllocator newRoot(SabotConfig config) {
        return InternalFactory.newRoot(config.getLong(TOP_LEVEL_MAX_ALLOC), 0L, 100);
    }

    public static BufferAllocator newRoot(DremioConfig config) {
        return InternalFactory.newRoot(config.getSabotConfig().getLong(TOP_LEVEL_MAX_ALLOC), config.getLong("debug.alloc.est_heap_buf_size_bytes"), config.getInt("debug.alloc.max_occupancy_percent"));
    }

    private static final class InternalFactory {
        private InternalFactory() {
        }

        private static DremioRootAllocator newRoot(long maxAllocBytes, long estBytesPerBuf, int maxOccupancyPercent) {
            long maxBuffers = estBytesPerBuf > 0L ? (long)((double)(VM.getMaxHeapMemory() * (long)maxOccupancyPercent) * 0.01 / (double)estBytesPerBuf) : Long.MAX_VALUE;
            return DremioRootAllocator.create(Math.min(VM.getMaxDirectMemory(), maxAllocBytes), maxBuffers);
        }

        private static void checkPoolConfiguration() {
            boolean value = PooledByteBufAllocator.defaultUseCacheForAllThreads();
            if (value) {
                LOGGER.error("!!! Root allocator configured to use cache for all threads !!! Expect memory issues");
            }
        }

        static {
            LOGGER.debug("Configuring Netty allocator");
            String previousProperty = System.getProperty(RootAllocatorFactory.IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY);
            try {
                System.setProperty(RootAllocatorFactory.IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY, "false");
                InternalFactory.checkPoolConfiguration();
            }
            finally {
                if (previousProperty == null) {
                    System.getProperties().remove(RootAllocatorFactory.IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY);
                } else {
                    System.setProperty(RootAllocatorFactory.IO_NETTY_ALLOCATOR_USE_CACHE_FOR_ALL_THREADS_PROPERTY, previousProperty);
                }
            }
        }
    }
}

