/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.BaseFixedWidthVector;
import cdjd.org.apache.arrow.vector.BitVectorHelper;
import cdjd.org.apache.arrow.vector.NullCheckingForGet;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.complex.impl.FixedSizeBinaryReaderImpl;
import cdjd.org.apache.arrow.vector.complex.reader.FieldReader;
import cdjd.org.apache.arrow.vector.holders.FixedSizeBinaryHolder;
import cdjd.org.apache.arrow.vector.holders.NullableFixedSizeBinaryHolder;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.TransferPair;

public class FixedSizeBinaryVector
extends BaseFixedWidthVector {
    private final int byteWidth;
    private final FieldReader reader = new FixedSizeBinaryReaderImpl(this);

    public FixedSizeBinaryVector(String name, BufferAllocator allocator, int byteWidth) {
        this(name, FieldType.nullable(new ArrowType.FixedSizeBinary(byteWidth)), allocator);
    }

    public FixedSizeBinaryVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public FixedSizeBinaryVector(Field field, BufferAllocator allocator) {
        super(field, allocator, ((ArrowType.FixedSizeBinary)field.getFieldType().getType()).getByteWidth());
        this.byteWidth = ((ArrowType.FixedSizeBinary)field.getFieldType().getType()).getByteWidth();
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.FIXEDSIZEBINARY;
    }

    public byte[] get(int index) {
        assert (index >= 0);
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            return null;
        }
        byte[] dst = new byte[this.byteWidth];
        this.valueBuffer.getBytes((long)index * (long)this.byteWidth, dst, 0, this.byteWidth);
        return dst;
    }

    public void get(int index, NullableFixedSizeBinaryHolder holder) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.buffer = this.valueBuffer.slice((long)index * (long)this.byteWidth, this.byteWidth);
    }

    public byte[] getObject(int index) {
        return this.get(index);
    }

    public int getByteWidth() {
        return this.byteWidth;
    }

    public void set(int index, byte[] value) {
        assert (index >= 0);
        Preconditions.checkNotNull(value, "expecting a valid byte array");
        assert (this.byteWidth <= value.length);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.valueBuffer.setBytes((long)index * (long)this.byteWidth, value, 0, (long)this.byteWidth);
    }

    public void setSafe(int index, byte[] value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void set(int index, int isSet, byte[] value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, byte[] value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public void set(int index, ArrowBuf buffer) {
        assert (index >= 0);
        assert ((long)this.byteWidth <= buffer.capacity());
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.valueBuffer.setBytes((long)index * (long)this.byteWidth, buffer, 0L, (long)this.byteWidth);
    }

    public void setSafe(int index, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, buffer);
    }

    public void set(int index, int isSet, ArrowBuf buffer) {
        if (isSet > 0) {
            this.set(index, buffer);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, ArrowBuf buffer) {
        this.handleSafe(index);
        this.set(index, isSet, buffer);
    }

    public void set(int index, FixedSizeBinaryHolder holder) {
        assert (holder.byteWidth == this.byteWidth);
        this.set(index, holder.buffer);
    }

    public void setSafe(int index, FixedSizeBinaryHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, NullableFixedSizeBinaryHolder holder) {
        assert (holder.byteWidth == this.byteWidth);
        if (holder.isSet < 0) {
            throw new IllegalArgumentException("holder has a negative isSet value");
        }
        if (holder.isSet > 0) {
            this.set(index, holder.buffer);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, NullableFixedSizeBinaryHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public static byte[] get(ArrowBuf buffer, int index, int byteWidth) {
        byte[] dst = new byte[byteWidth];
        buffer.getBytes((long)index * (long)byteWidth, dst, 0, byteWidth);
        return dst;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((FixedSizeBinaryVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        FixedSizeBinaryVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new FixedSizeBinaryVector(ref, allocator, FixedSizeBinaryVector.this.byteWidth);
        }

        public TransferImpl(FixedSizeBinaryVector to) {
            this.to = to;
        }

        @Override
        public FixedSizeBinaryVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            FixedSizeBinaryVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            FixedSizeBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, FixedSizeBinaryVector.this);
        }
    }
}

