/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector;

import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.OutOfMemoryException;
import cdjd.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.BufferBacked;
import cdjd.org.apache.arrow.vector.FieldVector;
import cdjd.org.apache.arrow.vector.ValueVector;
import cdjd.org.apache.arrow.vector.compare.VectorVisitor;
import cdjd.org.apache.arrow.vector.complex.impl.NullReader;
import cdjd.org.apache.arrow.vector.complex.reader.FieldReader;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.types.Types;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.FieldType;
import cdjd.org.apache.arrow.vector.util.CallBack;
import cdjd.org.apache.arrow.vector.util.TransferPair;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NullVector
implements FieldVector {
    private int valueCount;

    @Override
    public void close() {
    }

    @Override
    public void clear() {
    }

    @Override
    public void reset() {
    }

    @Override
    public Field getField() {
        return new Field("$data$", FieldType.nullable(new ArrowType.Null()), null);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.NULL;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(null, allocator);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public int getBufferSize() {
        return 0;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        return new ArrowBuf[0];
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.allocateNewSafe();
    }

    @Override
    public boolean allocateNewSafe() {
        return true;
    }

    @Override
    public void reAlloc() {
    }

    @Override
    public BufferAllocator getAllocator() {
        throw new UnsupportedOperationException("Tried to get allocator from NullVector");
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return this.valueCount;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl();
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((NullVector)target);
    }

    @Override
    public FieldReader getReader() {
        return NullReader.INSTANCE;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("Null vector has no children");
        }
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.emptyList();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        Preconditions.checkArgument(ownBuffers.isEmpty(), "Null vector has no buffers");
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        return Collections.emptyList();
    }

    @Override
    public List<BufferBacked> getFieldInnerVectors() {
        return Collections.emptyList();
    }

    @Override
    public long getValidityBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
    }

    @Override
    public Object getObject(int index) {
        return null;
    }

    @Override
    public int getNullCount() {
        return this.valueCount;
    }

    @Override
    public boolean isNull(int index) {
        return true;
    }

    @Override
    public int hashCode(int index) {
        return 31 * this.valueCount;
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        return 31 * this.valueCount;
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyFromSafe(int fromIndex, int thisIndex, ValueVector from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.getField().getName();
    }

    private class TransferImpl
    implements TransferPair {
        NullVector to;

        public TransferImpl() {
            this.to = new NullVector();
        }

        public TransferImpl(NullVector to) {
            this.to = to;
        }

        @Override
        public NullVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            this.to.valueCount = NullVector.this.valueCount;
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            this.to.valueCount = length;
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            if (toIndex > this.to.valueCount) {
                this.to.valueCount = toIndex;
            }
        }
    }
}

