/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.complex;

import cdjd.com.dremio.common.expression.AbstractArrowTypeVisitor;
import cdjd.com.dremio.common.expression.BasePath;
import cdjd.com.dremio.common.expression.CompleteType;
import cdjd.com.dremio.common.expression.PathSegment;
import cdjd.com.dremio.exec.record.BatchSchema;
import cdjd.com.dremio.exec.record.TypedFieldId;
import cdjd.org.apache.arrow.vector.types.pojo.ArrowType;
import cdjd.org.apache.arrow.vector.types.pojo.Field;
import cdjd.org.apache.arrow.vector.types.pojo.Schema;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldIdUtil2 {
    private static final Logger logger = LoggerFactory.getLogger(FieldIdUtil2.class);

    private static TypedFieldId getFieldIdIfMatchesUnion(Field field, TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        if (seg == null) {
            if (addToBreadCrumb) {
                builder.intermediateType(CompleteType.fromField(field));
            }
            return builder.finalType(CompleteType.fromField(field)).build();
        }
        if (seg.isNamed()) {
            FieldWithOrdinal ford = FieldIdUtil2.getChildField(field, "struct");
            if (ford != null) {
                return FieldIdUtil2.getFieldIdIfMatches(ford.field, builder, addToBreadCrumb, seg);
            }
            return null;
        }
        if (seg.isArray()) {
            FieldWithOrdinal ford = FieldIdUtil2.getChildField(field, "list");
            if (ford != null) {
                return FieldIdUtil2.getFieldIdIfMatches(ford.field, builder, addToBreadCrumb, seg);
            }
            return null;
        }
        return null;
    }

    public static TypedFieldId getFieldId(BatchSchema schema, BasePath path) {
        boolean isHyper = schema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE;
        return FieldIdUtil2.getFieldId(schema, path, isHyper);
    }

    public static TypedFieldId getFieldId(Schema schema, BasePath path, boolean isHyper) {
        int i = 0;
        for (Field f : schema.getFields()) {
            TypedFieldId id = FieldIdUtil2.getFieldId(f, i, path, isHyper);
            if (id != null) {
                return id;
            }
            ++i;
        }
        return null;
    }

    public static TypedFieldId getFieldId(final Field field, final int id, final BasePath expectedPath, boolean hyper) {
        if (!expectedPath.getRootSegment().getNameSegment().getPath().equalsIgnoreCase(field.getName())) {
            return null;
        }
        final PathSegment.NameSegment seg = expectedPath.getRootSegment();
        final TypedFieldId.Builder builder = TypedFieldId.newBuilder();
        if (hyper) {
            builder.hyper();
        }
        return field.getType().accept(new AbstractArrowTypeVisitor<TypedFieldId>(){

            @Override
            public TypedFieldId visit(ArrowType.Struct incoming) {
                builder.intermediateType(CompleteType.fromField(field));
                builder.addId(id);
                return FieldIdUtil2.getFieldIdIfMatches(field, builder, true, expectedPath.getRootSegment().getChild());
            }

            @Override
            public TypedFieldId visit(ArrowType.List incoming) {
                builder.intermediateType(CompleteType.fromField(field));
                builder.addId(id);
                builder.isListOrUnionInPath(true);
                return FieldIdUtil2.getFieldIdIfMatches(field, builder, true, expectedPath.getRootSegment().getChild());
            }

            @Override
            public TypedFieldId visit(ArrowType.Union incoming) {
                builder.addId(id).remainder(expectedPath.getRootSegment().getChild());
                builder.isListOrUnionInPath(true);
                CompleteType type = CompleteType.fromField(field);
                builder.intermediateType(type);
                if (seg.isLastPath()) {
                    builder.finalType(type);
                    return builder.build();
                }
                return FieldIdUtil2.getFieldIdIfMatchesUnion(field, builder, false, seg.getChild());
            }

            @Override
            protected TypedFieldId visitGeneric(ArrowType type) {
                builder.intermediateType(CompleteType.fromField(field));
                builder.addId(id);
                builder.finalType(CompleteType.fromField(field));
                if (seg.isLastPath()) {
                    return builder.build();
                }
                PathSegment child = seg.getChild();
                if (child.isArray() && child.isLastPath()) {
                    builder.remainder(child);
                    builder.withIndex();
                    builder.finalType(CompleteType.fromField(field));
                    return builder.build();
                }
                return null;
            }
        });
    }

    private static TypedFieldId getFieldIdIfMatches(Field field, TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        Field inner;
        if (seg == null) {
            if (addToBreadCrumb) {
                builder.intermediateType(CompleteType.fromField(field));
            }
            return builder.finalType(CompleteType.fromField(field)).build();
        }
        ArrowType.ArrowTypeID typeType = field.getType().getTypeID();
        if (seg.isArray()) {
            builder.isListOrUnionInPath(true);
            if (seg.isLastPath()) {
                CompleteType type;
                if (typeType == ArrowType.ArrowTypeID.Struct) {
                    type = CompleteType.fromField(field);
                } else if (typeType == ArrowType.ArrowTypeID.List) {
                    type = CompleteType.fromField(field.getChildren().get(0));
                    builder.isListOrUnionInPath(true);
                    builder.listVector();
                } else {
                    throw new UnsupportedOperationException("FieldIdUtil does not support field of type " + field.getType());
                }
                builder.withIndex().finalType(type);
                if (addToBreadCrumb) {
                    addToBreadCrumb = false;
                    builder.remainder(seg);
                }
                return builder.build();
            }
            if (addToBreadCrumb) {
                addToBreadCrumb = false;
                builder.remainder(seg);
            }
        } else if (typeType == ArrowType.ArrowTypeID.List) {
            builder.isListOrUnionInPath(true);
            return null;
        }
        if (typeType == ArrowType.ArrowTypeID.Struct) {
            if (seg.isArray()) {
                builder.isListOrUnionInPath(true);
                return null;
            }
            FieldWithOrdinal ford = FieldIdUtil2.getChildField(field, seg.isArray() ? null : seg.getNameSegment().getPath());
            if (ford == null) {
                return null;
            }
            inner = ford.field;
            if (addToBreadCrumb) {
                builder.intermediateType(CompleteType.fromField(inner));
                builder.addId(ford.ordinal);
            }
        } else if (typeType == ArrowType.ArrowTypeID.List) {
            builder.isListOrUnionInPath(true);
            inner = field.getChildren().get(0);
        } else {
            throw new UnsupportedOperationException("FieldIdUtil does not support field of type " + field.getType());
        }
        ArrowType.ArrowTypeID innerTypeType = inner.getType().getTypeID();
        if (innerTypeType == ArrowType.ArrowTypeID.List || innerTypeType == ArrowType.ArrowTypeID.Struct) {
            if (innerTypeType == ArrowType.ArrowTypeID.List) {
                builder.isListOrUnionInPath(true);
            }
            return FieldIdUtil2.getFieldIdIfMatches(inner, builder, addToBreadCrumb, seg.getChild());
        }
        if (innerTypeType == ArrowType.ArrowTypeID.Union) {
            builder.isListOrUnionInPath(true);
            return FieldIdUtil2.getFieldIdIfMatchesUnion(inner, builder, addToBreadCrumb, seg.getChild());
        }
        if (seg.isNamed()) {
            if (addToBreadCrumb) {
                builder.intermediateType(CompleteType.fromField(inner));
            }
            builder.finalType(CompleteType.fromField(inner));
        } else {
            builder.finalType(CompleteType.fromField(inner));
        }
        if (seg.isLastPath()) {
            return builder.build();
        }
        PathSegment child = seg.getChild();
        if (child.isLastPath() && child.isArray()) {
            builder.isListOrUnionInPath(true);
            if (addToBreadCrumb) {
                builder.remainder(child);
            }
            builder.finalType(CompleteType.fromField(inner));
            return builder.build();
        }
        logger.warn("You tried to request a complex type inside a scalar object or path or type is wrong.");
        return null;
    }

    private static FieldWithOrdinal getChildField(Field f, String name) {
        HashMap<String, FieldWithOrdinal> children = new HashMap<String, FieldWithOrdinal>();
        int i = 0;
        for (Field child : f.getChildren()) {
            children.put(child.getName().toLowerCase(), new FieldWithOrdinal(child, i));
            ++i;
        }
        return (FieldWithOrdinal)children.get(name.toLowerCase());
    }

    private static class FieldWithOrdinal {
        private final Field field;
        private final int ordinal;

        public FieldWithOrdinal(Field field, int ordinal) {
            this.field = field;
            this.ordinal = ordinal;
        }
    }
}

