/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.ipc.message;

import cdjd.com.google.flatbuffers.FlatBufferBuilder;
import cdjd.org.apache.arrow.flatbuf.Buffer;
import cdjd.org.apache.arrow.flatbuf.DictionaryBatch;
import cdjd.org.apache.arrow.flatbuf.FieldNode;
import cdjd.org.apache.arrow.flatbuf.Message;
import cdjd.org.apache.arrow.flatbuf.RecordBatch;
import cdjd.org.apache.arrow.flatbuf.Schema;
import cdjd.org.apache.arrow.memory.ArrowBuf;
import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.memory.util.LargeMemoryUtil;
import cdjd.org.apache.arrow.util.Preconditions;
import cdjd.org.apache.arrow.vector.compression.NoCompressionCodec;
import cdjd.org.apache.arrow.vector.ipc.ReadChannel;
import cdjd.org.apache.arrow.vector.ipc.WriteChannel;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowBlock;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowBodyCompression;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowBuffer;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowMessage;
import cdjd.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import cdjd.org.apache.arrow.vector.ipc.message.IpcOption;
import cdjd.org.apache.arrow.vector.ipc.message.MessageChannelReader;
import cdjd.org.apache.arrow.vector.ipc.message.MessageMetadataResult;
import cdjd.org.apache.arrow.vector.ipc.message.MessageResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MessageSerializer {
    public static final int IPC_CONTINUATION_TOKEN = -1;

    public static int bytesToInt(byte[] bytes) {
        return ((bytes[3] & 0xFF) << 24) + ((bytes[2] & 0xFF) << 16) + ((bytes[1] & 0xFF) << 8) + (bytes[0] & 0xFF);
    }

    public static void intToBytes(int value, byte[] bytes) {
        bytes[3] = (byte)(value >>> 24);
        bytes[2] = (byte)(value >>> 16);
        bytes[1] = (byte)(value >>> 8);
        bytes[0] = (byte)value;
    }

    public static void longToBytes(long value, byte[] bytes) {
        bytes[7] = (byte)(value >>> 56);
        bytes[6] = (byte)(value >>> 48);
        bytes[5] = (byte)(value >>> 40);
        bytes[4] = (byte)(value >>> 32);
        bytes[3] = (byte)(value >>> 24);
        bytes[2] = (byte)(value >>> 16);
        bytes[1] = (byte)(value >>> 8);
        bytes[0] = (byte)value;
    }

    public static int writeMessageBuffer(WriteChannel out, int messageLength, ByteBuffer messageBuffer) throws IOException {
        return MessageSerializer.writeMessageBuffer(out, messageLength, messageBuffer, IpcOption.DEFAULT);
    }

    public static int writeMessageBuffer(WriteChannel out, int messageLength, ByteBuffer messageBuffer, IpcOption option) throws IOException {
        int prefixSize;
        int n = prefixSize = option.write_legacy_ipc_format ? 4 : 8;
        if ((messageLength + prefixSize) % 8 != 0) {
            messageLength += 8 - (messageLength + prefixSize) % 8;
        }
        if (!option.write_legacy_ipc_format) {
            out.writeIntLittleEndian(-1);
        }
        out.writeIntLittleEndian(messageLength);
        out.write(messageBuffer);
        out.align();
        return messageLength + prefixSize;
    }

    public static long serialize(WriteChannel out, cdjd.org.apache.arrow.vector.types.pojo.Schema schema) throws IOException {
        return MessageSerializer.serialize(out, schema, IpcOption.DEFAULT);
    }

    public static long serialize(WriteChannel out, cdjd.org.apache.arrow.vector.types.pojo.Schema schema, IpcOption option) throws IOException {
        long start = out.getCurrentPosition();
        Preconditions.checkArgument(start % 8L == 0L, "out is not aligned");
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata(schema, option);
        int messageLength = serializedMessage.remaining();
        int bytesWritten = MessageSerializer.writeMessageBuffer(out, messageLength, serializedMessage, option);
        Preconditions.checkArgument(bytesWritten % 8 == 0, "out is not aligned");
        return bytesWritten;
    }

    @Deprecated
    public static ByteBuffer serializeMetadata(cdjd.org.apache.arrow.vector.types.pojo.Schema schema) {
        return MessageSerializer.serializeMetadata(schema, IpcOption.DEFAULT);
    }

    public static ByteBuffer serializeMetadata(cdjd.org.apache.arrow.vector.types.pojo.Schema schema, IpcOption writeOption) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int schemaOffset = schema.getSchema(builder);
        return MessageSerializer.serializeMessage(builder, (byte)1, schemaOffset, 0L, writeOption);
    }

    public static cdjd.org.apache.arrow.vector.types.pojo.Schema deserializeSchema(Message schemaMessage) {
        Preconditions.checkArgument(schemaMessage.headerType() == 1, "Expected schema but result was:  %s", schemaMessage.headerType());
        return cdjd.org.apache.arrow.vector.types.pojo.Schema.convertSchema((Schema)schemaMessage.header(new Schema()));
    }

    public static cdjd.org.apache.arrow.vector.types.pojo.Schema deserializeSchema(ReadChannel in) throws IOException {
        MessageMetadataResult result = MessageSerializer.readMessage(in);
        if (result == null) {
            throw new IOException("Unexpected end of input when reading Schema");
        }
        if (result.getMessage().headerType() != 1) {
            throw new IOException("Expected schema but header was " + result.getMessage().headerType());
        }
        return MessageSerializer.deserializeSchema(result);
    }

    public static cdjd.org.apache.arrow.vector.types.pojo.Schema deserializeSchema(MessageMetadataResult message) {
        return MessageSerializer.deserializeSchema(message.getMessage());
    }

    public static ArrowBlock serialize(WriteChannel out, ArrowRecordBatch batch) throws IOException {
        return MessageSerializer.serialize(out, batch, IpcOption.DEFAULT);
    }

    public static ArrowBlock serialize(WriteChannel out, ArrowRecordBatch batch, IpcOption option) throws IOException {
        int padding;
        long start = out.getCurrentPosition();
        long bodyLength = batch.computeBodyLength();
        Preconditions.checkArgument(bodyLength % 8L == 0L, "batch is not aligned");
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata(batch, option);
        int metadataLength = serializedMessage.remaining();
        int prefixSize = 4;
        if (!option.write_legacy_ipc_format) {
            out.writeIntLittleEndian(-1);
            prefixSize = 8;
        }
        if ((padding = (int)((start + (long)metadataLength + (long)prefixSize) % 8L)) != 0) {
            metadataLength += 8 - padding;
        }
        out.writeIntLittleEndian(metadataLength);
        out.write(serializedMessage);
        out.align();
        long bufferLength = MessageSerializer.writeBatchBuffers(out, batch);
        Preconditions.checkArgument(bufferLength % 8L == 0L, "out is not aligned");
        return new ArrowBlock(start, metadataLength + prefixSize, bufferLength);
    }

    public static long writeBatchBuffers(WriteChannel out, ArrowRecordBatch batch) throws IOException {
        long bufferStart = out.getCurrentPosition();
        List<ArrowBuf> buffers = batch.getBuffers();
        List<ArrowBuffer> buffersLayout = batch.getBuffersLayout();
        for (int i = 0; i < buffers.size(); ++i) {
            ArrowBuf buffer = buffers.get(i);
            ArrowBuffer layout = buffersLayout.get(i);
            long startPosition = bufferStart + layout.getOffset();
            if (startPosition != out.getCurrentPosition()) {
                out.writeZeros(startPosition - out.getCurrentPosition());
            }
            out.write(buffer);
            if (out.getCurrentPosition() == startPosition + layout.getSize()) continue;
            throw new IllegalStateException("wrong buffer size: " + out.getCurrentPosition() + " != " + startPosition + layout.getSize());
        }
        out.align();
        return out.getCurrentPosition() - bufferStart;
    }

    @Deprecated
    public static ByteBuffer serializeMetadata(ArrowMessage message) {
        return MessageSerializer.serializeMetadata(message, IpcOption.DEFAULT);
    }

    public static ByteBuffer serializeMetadata(ArrowMessage message, IpcOption writeOption) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int batchOffset = message.writeTo(builder);
        return MessageSerializer.serializeMessage(builder, message.getMessageType(), batchOffset, message.computeBodyLength(), writeOption);
    }

    public static ArrowRecordBatch deserializeRecordBatch(Message recordBatchMessage, ArrowBuf bodyBuffer) throws IOException {
        RecordBatch recordBatchFB = (RecordBatch)recordBatchMessage.header(new RecordBatch());
        return MessageSerializer.deserializeRecordBatch(recordBatchFB, bodyBuffer);
    }

    public static ArrowRecordBatch deserializeRecordBatch(ReadChannel in, BufferAllocator allocator) throws IOException {
        MessageMetadataResult result = MessageSerializer.readMessage(in);
        if (result == null) {
            throw new IOException("Unexpected end of input when reading a RecordBatch");
        }
        if (result.getMessage().headerType() != 3) {
            throw new IOException("Expected RecordBatch but header was " + result.getMessage().headerType());
        }
        long bodyLength = result.getMessageBodyLength();
        ArrowBuf bodyBuffer = MessageSerializer.readMessageBody(in, bodyLength, allocator);
        return MessageSerializer.deserializeRecordBatch(result.getMessage(), bodyBuffer);
    }

    public static ArrowRecordBatch deserializeRecordBatch(ReadChannel in, ArrowBlock block, BufferAllocator alloc) throws IOException {
        long totalLen = (long)block.getMetadataLength() + block.getBodyLength();
        ArrowBuf buffer = alloc.buffer(totalLen);
        if (in.readFully(buffer, totalLen) != totalLen) {
            throw new IOException("Unexpected end of input trying to read batch.");
        }
        int prefixSize = buffer.getInt(0L) == -1 ? 8 : 4;
        ArrowBuf metadataBuffer = buffer.slice(prefixSize, block.getMetadataLength() - prefixSize);
        Message messageFB = Message.getRootAsMessage(metadataBuffer.nioBuffer().asReadOnlyBuffer());
        RecordBatch recordBatchFB = (RecordBatch)messageFB.header(new RecordBatch());
        ArrowBuf body = buffer.slice(block.getMetadataLength(), totalLen - (long)block.getMetadataLength());
        return MessageSerializer.deserializeRecordBatch(recordBatchFB, body);
    }

    public static ArrowRecordBatch deserializeRecordBatch(RecordBatch recordBatchFB, ArrowBuf body) throws IOException {
        ArrowBodyCompression bodyCompression;
        int nodesLength = recordBatchFB.nodesLength();
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        for (int i = 0; i < nodesLength; ++i) {
            FieldNode node = recordBatchFB.nodes(i);
            if ((long)((int)node.length()) != node.length() || (long)((int)node.nullCount()) != node.nullCount()) {
                throw new IOException("Cannot currently deserialize record batches with node length larger than INT_MAX records.");
            }
            nodes.add(new ArrowFieldNode(node.length(), node.nullCount()));
        }
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        for (int i = 0; i < recordBatchFB.buffersLength(); ++i) {
            Buffer bufferFB = recordBatchFB.buffers(i);
            ArrowBuf vectorBuffer = body.slice(bufferFB.offset(), bufferFB.length());
            buffers.add(vectorBuffer);
        }
        ArrowBodyCompression arrowBodyCompression = bodyCompression = recordBatchFB.compression() == null ? NoCompressionCodec.DEFAULT_BODY_COMPRESSION : new ArrowBodyCompression(recordBatchFB.compression().codec(), recordBatchFB.compression().method());
        if ((long)((int)recordBatchFB.length()) != recordBatchFB.length()) {
            throw new IOException("Cannot currently deserialize record batches with more than INT_MAX records.");
        }
        ArrowRecordBatch arrowRecordBatch = new ArrowRecordBatch(LargeMemoryUtil.checkedCastToInt(recordBatchFB.length()), nodes, buffers, bodyCompression);
        body.getReferenceManager().release();
        return arrowRecordBatch;
    }

    public static ArrowRecordBatch deserializeRecordBatch(MessageMetadataResult serializedMessage, ArrowBuf underlying) throws IOException {
        return MessageSerializer.deserializeRecordBatch(serializedMessage.getMessage(), underlying);
    }

    public static ArrowBlock serialize(WriteChannel out, ArrowDictionaryBatch batch) throws IOException {
        return MessageSerializer.serialize(out, batch, IpcOption.DEFAULT);
    }

    public static ArrowBlock serialize(WriteChannel out, ArrowDictionaryBatch batch, IpcOption option) throws IOException {
        int padding;
        long start = out.getCurrentPosition();
        long bodyLength = batch.computeBodyLength();
        Preconditions.checkArgument(bodyLength % 8L == 0L, "batch is not aligned");
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata(batch, option);
        int metadataLength = serializedMessage.remaining();
        int prefixSize = 4;
        if (!option.write_legacy_ipc_format) {
            out.writeIntLittleEndian(-1);
            prefixSize = 8;
        }
        if ((padding = (int)((start + (long)metadataLength + (long)prefixSize) % 8L)) != 0) {
            metadataLength += 8 - padding;
        }
        out.writeIntLittleEndian(metadataLength);
        out.write(serializedMessage);
        out.align();
        long bufferLength = MessageSerializer.writeBatchBuffers(out, batch.getDictionary());
        Preconditions.checkArgument(bufferLength % 8L == 0L, "out is not aligned");
        return new ArrowBlock(start, metadataLength + prefixSize, bufferLength);
    }

    public static ArrowDictionaryBatch deserializeDictionaryBatch(Message message, ArrowBuf bodyBuffer) throws IOException {
        DictionaryBatch dictionaryBatchFB = (DictionaryBatch)message.header(new DictionaryBatch());
        ArrowRecordBatch recordBatch = MessageSerializer.deserializeRecordBatch(dictionaryBatchFB.data(), bodyBuffer);
        return new ArrowDictionaryBatch(dictionaryBatchFB.id(), recordBatch, dictionaryBatchFB.isDelta());
    }

    public static ArrowDictionaryBatch deserializeDictionaryBatch(MessageMetadataResult message, ArrowBuf bodyBuffer) throws IOException {
        return MessageSerializer.deserializeDictionaryBatch(message.getMessage(), bodyBuffer);
    }

    public static ArrowDictionaryBatch deserializeDictionaryBatch(ReadChannel in, BufferAllocator allocator) throws IOException {
        MessageMetadataResult result = MessageSerializer.readMessage(in);
        if (result == null) {
            throw new IOException("Unexpected end of input when reading a DictionaryBatch");
        }
        if (result.getMessage().headerType() != 2) {
            throw new IOException("Expected DictionaryBatch but header was " + result.getMessage().headerType());
        }
        long bodyLength = result.getMessageBodyLength();
        ArrowBuf bodyBuffer = MessageSerializer.readMessageBody(in, bodyLength, allocator);
        return MessageSerializer.deserializeDictionaryBatch(result.getMessage(), bodyBuffer);
    }

    public static ArrowDictionaryBatch deserializeDictionaryBatch(ReadChannel in, ArrowBlock block, BufferAllocator alloc) throws IOException {
        long totalLen = (long)block.getMetadataLength() + block.getBodyLength();
        ArrowBuf buffer = alloc.buffer(totalLen);
        if (in.readFully(buffer, totalLen) != totalLen) {
            throw new IOException("Unexpected end of input trying to read batch.");
        }
        int prefixSize = buffer.getInt(0L) == -1 ? 8 : 4;
        ArrowBuf metadataBuffer = buffer.slice(prefixSize, block.getMetadataLength() - prefixSize);
        Message messageFB = Message.getRootAsMessage(metadataBuffer.nioBuffer().asReadOnlyBuffer());
        DictionaryBatch dictionaryBatchFB = (DictionaryBatch)messageFB.header(new DictionaryBatch());
        ArrowBuf body = buffer.slice(block.getMetadataLength(), totalLen - (long)block.getMetadataLength());
        ArrowRecordBatch recordBatch = MessageSerializer.deserializeRecordBatch(dictionaryBatchFB.data(), body);
        return new ArrowDictionaryBatch(dictionaryBatchFB.id(), recordBatch, dictionaryBatchFB.isDelta());
    }

    public static ArrowMessage deserializeMessageBatch(MessageChannelReader reader) throws IOException {
        MessageResult result = reader.readNext();
        if (result == null) {
            return null;
        }
        if (result.getMessage().bodyLength() > Integer.MAX_VALUE) {
            throw new IOException("Cannot currently deserialize record batches over 2GB");
        }
        if (result.getMessage().version() != 3 && result.getMessage().version() != 4) {
            throw new IOException("Received metadata with an incompatible version number: " + result.getMessage().version());
        }
        switch (result.getMessage().headerType()) {
            case 3: {
                return MessageSerializer.deserializeRecordBatch(result.getMessage(), result.getBodyBuffer());
            }
            case 2: {
                return MessageSerializer.deserializeDictionaryBatch(result.getMessage(), result.getBodyBuffer());
            }
        }
        throw new IOException("Unexpected message header type " + result.getMessage().headerType());
    }

    public static ArrowMessage deserializeMessageBatch(ReadChannel in, BufferAllocator alloc) throws IOException {
        return MessageSerializer.deserializeMessageBatch(new MessageChannelReader(in, alloc));
    }

    @Deprecated
    public static ByteBuffer serializeMessage(FlatBufferBuilder builder, byte headerType, int headerOffset, long bodyLength) {
        return MessageSerializer.serializeMessage(builder, headerType, headerOffset, bodyLength, IpcOption.DEFAULT);
    }

    public static ByteBuffer serializeMessage(FlatBufferBuilder builder, byte headerType, int headerOffset, long bodyLength, IpcOption writeOption) {
        Message.startMessage(builder);
        Message.addHeaderType(builder, headerType);
        Message.addHeader(builder, headerOffset);
        Message.addVersion(builder, writeOption.metadataVersion.toFlatbufID());
        Message.addBodyLength(builder, bodyLength);
        builder.finish(Message.endMessage(builder));
        return builder.dataBuffer();
    }

    public static MessageMetadataResult readMessage(ReadChannel in) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        if (in.readFully(buffer) == 4) {
            int messageLength = MessageSerializer.bytesToInt(buffer.array());
            if (messageLength == -1) {
                buffer.clear();
                if (in.readFully(buffer) == 4) {
                    messageLength = MessageSerializer.bytesToInt(buffer.array());
                }
            }
            if (messageLength != 0) {
                ByteBuffer messageBuffer = ByteBuffer.allocate(messageLength);
                if (in.readFully(messageBuffer) != messageLength) {
                    throw new IOException("Unexpected end of stream trying to read message.");
                }
                messageBuffer.rewind();
                Message message = Message.getRootAsMessage(messageBuffer);
                return new MessageMetadataResult(messageLength, messageBuffer, message);
            }
        }
        return null;
    }

    public static ArrowBuf readMessageBody(ReadChannel in, long bodyLength, BufferAllocator allocator) throws IOException {
        ArrowBuf bodyBuffer = allocator.buffer(bodyLength);
        if (in.readFully(bodyBuffer, bodyLength) != bodyLength) {
            throw new IOException("Unexpected end of input trying to read batch.");
        }
        return bodyBuffer;
    }
}

