/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.util;

import cdjd.org.apache.arrow.memory.util.ArrowBufPointer;
import cdjd.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import cdjd.org.apache.arrow.memory.util.hash.SimpleHasher;
import cdjd.org.apache.arrow.vector.ElementAddressableVector;
import java.util.Iterator;

public class ElementAddressableVectorIterator<T extends ElementAddressableVector>
implements Iterator<ArrowBufPointer> {
    private final T vector;
    private int index = 0;
    private final ArrowBufPointer reusablePointer;

    public ElementAddressableVectorIterator(T vector) {
        this(vector, SimpleHasher.INSTANCE);
    }

    public ElementAddressableVectorIterator(T vector, ArrowBufHasher hasher) {
        this.vector = vector;
        this.reusablePointer = new ArrowBufPointer(hasher);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.vector.getValueCount();
    }

    @Override
    public ArrowBufPointer next() {
        this.vector.getDataPointer(this.index, this.reusablePointer);
        ++this.index;
        return this.reusablePointer;
    }

    public void next(ArrowBufPointer outPointer) {
        this.vector.getDataPointer(this.index, outPointer);
        ++this.index;
    }
}

