/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.arrow.vector.util;

import cdjd.org.apache.arrow.memory.BufferAllocator;
import cdjd.org.apache.arrow.vector.ipc.ReadChannel;
import cdjd.org.apache.arrow.vector.ipc.WriteChannel;
import cdjd.org.apache.arrow.vector.ipc.message.MessageChannelReader;
import cdjd.org.apache.arrow.vector.ipc.message.MessageResult;
import cdjd.org.apache.arrow.vector.ipc.message.MessageSerializer;
import cdjd.org.apache.arrow.vector.types.pojo.Schema;
import cdjd.org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;

public class SchemaUtility {
    private SchemaUtility() {
    }

    public static Schema deserialize(byte[] bytes, BufferAllocator allocator) throws IOException {
        try (MessageChannelReader schemaReader = new MessageChannelReader(new ReadChannel(new ByteArrayReadableSeekableByteChannel(bytes)), allocator);){
            MessageResult result = schemaReader.readNext();
            if (result == null) {
                throw new IOException("Unexpected end of input. Missing schema.");
            }
            Schema schema = MessageSerializer.deserializeSchema(result.getMessage());
            return schema;
        }
    }

    public static byte[] serialize(Schema schema) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageSerializer.serialize(new WriteChannel(Channels.newChannel(out)), schema);
        return out.toByteArray();
    }
}

