/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.calcite.avatica.remote;

import cdjd.org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientImpl;
import cdjd.org.apache.http.HttpEntity;
import cdjd.org.apache.http.auth.AuthScope;
import cdjd.org.apache.http.auth.Credentials;
import cdjd.org.apache.http.auth.KerberosCredentials;
import cdjd.org.apache.http.client.AuthCache;
import cdjd.org.apache.http.client.methods.CloseableHttpResponse;
import cdjd.org.apache.http.client.methods.HttpPost;
import cdjd.org.apache.http.client.methods.HttpUriRequest;
import cdjd.org.apache.http.client.protocol.HttpClientContext;
import cdjd.org.apache.http.config.Registry;
import cdjd.org.apache.http.config.RegistryBuilder;
import cdjd.org.apache.http.conn.socket.ConnectionSocketFactory;
import cdjd.org.apache.http.entity.ByteArrayEntity;
import cdjd.org.apache.http.entity.ContentType;
import cdjd.org.apache.http.impl.auth.SPNegoSchemeFactory;
import cdjd.org.apache.http.impl.client.BasicCredentialsProvider;
import cdjd.org.apache.http.protocol.HttpContext;
import cdjd.org.apache.http.util.EntityUtils;
import cdjd.org.ietf.jgss.GSSCredential;
import java.net.URL;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaCommonsHttpClientSpnegoImpl
extends AvaticaCommonsHttpClientImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientSpnegoImpl.class);
    public static final String CACHED_CONNECTIONS_MAX_KEY = "avatica.http.spnego.max_cached";
    public static final String CACHED_CONNECTIONS_MAX_PER_ROUTE_KEY = "avatica.http.spnego.max_per_route";
    private static final boolean USE_CANONICAL_HOSTNAME = Boolean.parseBoolean(System.getProperty("avatica.http.spnego.use_canonical_hostname", "true"));
    private static final boolean STRIP_PORT_ON_SERVER_LOOKUP = true;

    public AvaticaCommonsHttpClientSpnegoImpl(URL url) {
        this(url, null);
    }

    public AvaticaCommonsHttpClientSpnegoImpl(URL url, GSSCredential credential) {
        super(url);
        this.setGSSCredential(credential);
    }

    @Override
    protected void configureConnectionPool(Registry<ConnectionSocketFactory> registry) {
        String maxCnxnsPerRoute;
        super.configureConnectionPool(registry);
        String maxCnxns = System.getProperty(CACHED_CONNECTIONS_MAX_KEY);
        if (maxCnxns != null) {
            this.pool.setMaxTotal(Integer.parseInt(maxCnxns));
        }
        if ((maxCnxnsPerRoute = System.getProperty(CACHED_CONNECTIONS_MAX_PER_ROUTE_KEY)) != null) {
            this.pool.setDefaultMaxPerRoute(Integer.parseInt(maxCnxnsPerRoute));
        }
    }

    public void setGSSCredential(GSSCredential credential) {
        this.authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, USE_CANONICAL_HOSTNAME)).build();
        this.credentialsProvider = new BasicCredentialsProvider();
        if (null != credential) {
            this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(credential));
        } else {
            this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)EmptyCredentials.INSTANCE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        HttpClientContext context = HttpClientContext.create();
        context.setTargetHost(this.host);
        context.setCredentialsProvider(this.credentialsProvider);
        context.setAuthSchemeRegistry(this.authRegistry);
        context.setAuthCache((AuthCache)this.authCache);
        ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
        HttpPost post = new HttpPost(this.uri);
        post.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)post, (HttpContext)context);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode || 500 == statusCode) {
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                return byArray;
            }
            throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug("Failed to execute HTTP request", e);
            throw new RuntimeException(e);
        }
    }

    private static class EmptyCredentials
    implements Credentials {
        public static final EmptyCredentials INSTANCE = new EmptyCredentials();

        private EmptyCredentials() {
        }

        public String getPassword() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }
    }
}

