/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.calcite.avatica.util;

import cdjd.org.apache.calcite.avatica.util.AbstractCursor;
import cdjd.org.apache.calcite.avatica.util.StructImpl;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public abstract class PositionedCursor<T>
extends AbstractCursor {
    protected abstract T current();

    protected class MapGetter<K>
    extends AbstractCursor.AbstractGetter {
        protected final K key;

        public MapGetter(K key) {
            this.key = key;
        }

        @Override
        public Object getObject() throws SQLException {
            Object o;
            try {
                Map map = (Map)PositionedCursor.this.current();
                o = map.get(this.key);
            }
            catch (RuntimeException e) {
                throw new SQLException(e);
            }
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class FieldGetter
    extends AbstractCursor.AbstractGetter {
        protected final Field field;

        public FieldGetter(Field field) {
            this.field = field;
        }

        @Override
        public Object getObject() throws SQLException {
            Object o;
            try {
                o = this.field.get(PositionedCursor.this.current());
            }
            catch (IllegalAccessException | RuntimeException e) {
                throw new SQLException(e);
            }
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ObjectGetter
    extends AbstractCursor.AbstractGetter {
        public ObjectGetter(int field) {
            assert (field == 0);
        }

        @Override
        public Object getObject() throws SQLException {
            Object o;
            try {
                o = PositionedCursor.this.current();
            }
            catch (RuntimeException e) {
                throw new SQLException(e);
            }
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ListGetter
    extends AbstractCursor.AbstractGetter {
        protected final int index;

        public ListGetter(int index) {
            this.index = index;
        }

        @Override
        public Object getObject() throws SQLException {
            Object o;
            try {
                o = ((List)PositionedCursor.this.current()).get(this.index);
            }
            catch (RuntimeException e) {
                throw new SQLException(e);
            }
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ArrayGetter
    extends AbstractCursor.AbstractGetter {
        protected final int field;

        public ArrayGetter(int field) {
            this.field = field;
        }

        @Override
        public Object getObject() throws SQLException {
            Object o;
            try {
                Object collection = PositionedCursor.this.current();
                o = collection instanceof List ? ((List)collection).get(this.field) : (collection instanceof StructImpl ? ((StructImpl)collection).getAttributes()[this.field] : ((Object[])collection)[this.field]);
            }
            catch (RuntimeException e) {
                throw new SQLException(e);
            }
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }
}

