/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.curator.framework.imps;

import cdjd.org.apache.curator.framework.CuratorFramework;
import cdjd.org.apache.curator.framework.imps.CuratorFrameworkState;
import cdjd.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import cdjd.org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FailedOperationManager<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final CuratorFramework client;
    @VisibleForTesting
    volatile FailedOperationManagerListener<T> debugListener = null;

    FailedOperationManager(CuratorFramework client) {
        this.client = client;
    }

    void addFailedOperation(T details) {
        if (this.debugListener != null) {
            this.debugListener.pathAddedForGuaranteedOperation(details);
        }
        if (this.client.getState() == CuratorFrameworkState.STARTED) {
            this.log.debug("Details being added to guaranteed operation set: " + details);
            try {
                this.executeGuaranteedOperationInBackground(details);
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                this.addFailedOperation(details);
            }
        }
    }

    protected abstract void executeGuaranteedOperationInBackground(T var1) throws Exception;

    static interface FailedOperationManagerListener<T> {
        public void pathAddedForGuaranteedOperation(T var1);
    }
}

