/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.apache.zookeeper.server.quorum;

import cdjd.org.apache.zookeeper.server.Request;
import cdjd.org.apache.zookeeper.server.RequestProcessor;
import cdjd.org.apache.zookeeper.server.quorum.Learner;
import cdjd.org.apache.zookeeper.server.quorum.QuorumPacket;
import java.io.Flushable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAckRequestProcessor
implements RequestProcessor,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(SendAckRequestProcessor.class);
    Learner learner;

    SendAckRequestProcessor(Learner peer) {
        this.learner = peer;
    }

    @Override
    public void processRequest(Request si) {
        if (si.type != 9) {
            QuorumPacket qp = new QuorumPacket(3, si.hdr.getZxid(), null, null);
            try {
                this.learner.writePacket(qp, false);
            }
            catch (IOException e) {
                LOG.warn("Closing connection to leader, exception during packet send", e);
                try {
                    if (!this.learner.sock.isClosed()) {
                        this.learner.sock.close();
                    }
                }
                catch (IOException e1) {
                    LOG.debug("Ignoring error closing the connection", e1);
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.learner.writePacket(null, true);
        }
        catch (IOException e) {
            LOG.warn("Closing connection to leader, exception during packet send", e);
            try {
                if (!this.learner.sock.isClosed()) {
                    this.learner.sock.close();
                }
            }
            catch (IOException e1) {
                LOG.debug("Ignoring error closing the connection", e1);
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

