/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.channel;

import cdjd.org.jboss.netty.channel.Channel;
import cdjd.org.jboss.netty.channel.ChannelFuture;
import cdjd.org.jboss.netty.channel.Channels;
import cdjd.org.jboss.netty.channel.MessageEvent;
import cdjd.org.jboss.netty.util.internal.StringUtil;
import java.net.SocketAddress;

public class UpstreamMessageEvent
implements MessageEvent {
    private final Channel channel;
    private final Object message;
    private final SocketAddress remoteAddress;

    public UpstreamMessageEvent(Channel channel, Object message, SocketAddress remoteAddress) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.channel = channel;
        this.message = message;
        this.remoteAddress = remoteAddress != null ? remoteAddress : channel.getRemoteAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    public Object getMessage() {
        return this.message;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String toString() {
        if (this.getRemoteAddress() == this.getChannel().getRemoteAddress()) {
            return this.getChannel().toString() + " RECEIVED: " + StringUtil.stripControlCharacters(this.getMessage());
        }
        return this.getChannel().toString() + " RECEIVED: " + StringUtil.stripControlCharacters(this.getMessage()) + " from " + this.getRemoteAddress();
    }
}

