/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.jboss.netty.handler.ssl;

import cdjd.org.jboss.netty.buffer.ChannelBuffer;
import cdjd.org.jboss.netty.buffer.ChannelBuffers;
import cdjd.org.jboss.netty.handler.codec.base64.Base64;
import cdjd.org.jboss.netty.logging.InternalLogger;
import cdjd.org.jboss.netty.logging.InternalLoggerFactory;
import cdjd.org.jboss.netty.util.CharsetUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PemReader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PemReader.class);
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);

    static ChannelBuffer[] readCertificates(File file) throws CertificateException {
        String content;
        try {
            content = PemReader.readContent(file);
        }
        catch (IOException e) {
            throw new CertificateException("failed to read a file: " + file, e);
        }
        ArrayList<ChannelBuffer> certs = new ArrayList<ChannelBuffer>();
        Matcher m3 = CERT_PATTERN.matcher(content);
        int start = 0;
        while (m3.find(start)) {
            certs.add(Base64.decode(ChannelBuffers.copiedBuffer(m3.group(1), CharsetUtil.US_ASCII)));
            start = m3.end();
        }
        if (certs.isEmpty()) {
            throw new CertificateException("found no certificates: " + file);
        }
        return certs.toArray(new ChannelBuffer[certs.size()]);
    }

    static ChannelBuffer readPrivateKey(File file) throws KeyException {
        String content;
        try {
            content = PemReader.readContent(file);
        }
        catch (IOException e) {
            throw new KeyException("failed to read a file: " + file, e);
        }
        Matcher m3 = KEY_PATTERN.matcher(content);
        if (!m3.find()) {
            throw new KeyException("found no private key: " + file);
        }
        return Base64.decode(ChannelBuffers.copiedBuffer(m3.group(1), CharsetUtil.US_ASCII));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readContent(File file) throws IOException {
        String string;
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int ret;
            byte[] buf = new byte[8192];
            while ((ret = ((InputStream)in).read(buf)) >= 0) {
                out.write(buf, 0, ret);
            }
            string = out.toString(CharsetUtil.US_ASCII.name());
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            PemReader.safeClose(in);
            PemReader.safeClose(out);
            throw throwable;
        }
        PemReader.safeClose(in);
        PemReader.safeClose(out);
        return string;
    }

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a stream.", e);
        }
    }

    private static void safeClose(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a stream.", e);
        }
    }

    private PemReader() {
    }
}

