/*
 * Decompiled with CFR 0.152.
 */
package cdjd.org.joda.time.chrono;

import cdjd.org.joda.time.Chronology;
import cdjd.org.joda.time.DateTimeFieldType;
import cdjd.org.joda.time.DurationField;
import cdjd.org.joda.time.chrono.GJLocaleSymbols;
import cdjd.org.joda.time.field.PreciseDurationDateTimeField;
import java.util.Locale;

final class DayOfWeekFromSundayDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = 8020294841735395909L;
    private final Chronology chronology;

    DayOfWeekFromSundayDateTimeField(Chronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfWeek(), days);
        this.chronology = chronology;
    }

    private static int map(int i) {
        return i % 7 + 1;
    }

    private static int reverse(int i) {
        int tmp = (i + 6) % 7;
        return tmp == 0 ? 7 : tmp;
    }

    @Override
    public int get(long instant) {
        return DayOfWeekFromSundayDateTimeField.map(this.chronology.dayOfWeek().get(instant));
    }

    @Override
    public String getAsText(int fieldValue, Locale locale) {
        return this.chronology.dayOfWeek().getAsText(DayOfWeekFromSundayDateTimeField.reverse(fieldValue), locale);
    }

    @Override
    public String getAsShortText(int fieldValue, Locale locale) {
        return this.chronology.dayOfWeek().getAsShortText(DayOfWeekFromSundayDateTimeField.reverse(fieldValue), locale);
    }

    @Override
    protected int convertText(String text, Locale locale) {
        return DayOfWeekFromSundayDateTimeField.map(GJLocaleSymbols.forLocale(locale).dayOfWeekTextToValue(text));
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.chronology.weeks();
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return 7;
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        return this.chronology.dayOfWeek().getMaximumTextLength(locale);
    }

    @Override
    public int getMaximumShortTextLength(Locale locale) {
        return this.chronology.dayOfWeek().getMaximumShortTextLength(locale);
    }

    private Object readResolve() {
        return this.chronology.dayOfWeek();
    }

    @Override
    public String toString() {
        return "DayOfWeekFromSundayDateTimeField[" + this.getName() + ']';
    }
}

