/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import cdjd.com.dremio.common.config.SabotConfig;
import cdjd.com.dremio.common.util.DremioVersionInfo;
import cdjd.org.apache.calcite.avatica.AvaticaConnection;
import cdjd.org.apache.calcite.avatica.DriverVersion;
import cdjd.org.apache.calcite.avatica.Handler;
import cdjd.org.apache.calcite.avatica.Meta;
import cdjd.org.apache.calcite.avatica.UnregisteredDriver;
import com.dremio.jdbc.impl.DremioConnectionImpl;
import com.dremio.jdbc.impl.DremioHandler;
import com.dremio.jdbc.impl.DremioMetaImpl;

public class DriverImpl
extends UnregisteredDriver {
    private static final String CONNECTION_STRING_PREFIX = "jdbc:dremio:";
    private static final String METADATA_PROPERTIES_RESOURCE_PATH = "dremio-jdbc.properties";
    private SabotConfig sabotConfig;

    @Override
    protected String getConnectStringPrefix() {
        return CONNECTION_STRING_PREFIX;
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                return "com.dremio.jdbc.impl.DremioJdbc3Factory";
            }
            case JDBC_40: {
                return "com.dremio.jdbc.impl.DremioJdbc40Factory";
            }
        }
        return "com.dremio.jdbc.impl.DremioJdbc41Factory";
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(this.getClass(), METADATA_PROPERTIES_RESOURCE_PATH, "Dremio JDBC Driver", DremioVersionInfo.getVersion(), "Dremio", "<Properties resource dremio-jdbc.properties not loaded>");
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        return new DremioMetaImpl((DremioConnectionImpl)connection);
    }

    @Override
    protected Handler createHandler() {
        return new DremioHandler();
    }

    SabotConfig getSabotConfig() {
        if (null == this.sabotConfig) {
            this.sabotConfig = SabotConfig.forClient();
        }
        return this.sabotConfig;
    }
}

