/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.druid;

import io.edurt.datacap.plugin.jdbc.druid.DruidAdapter;
import io.edurt.datacap.plugin.jdbc.druid.DruidConnection;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(DruidPlugin.class);
    private JdbcConfigure jdbcConfigure;
    private DruidConnection connection;
    private Response response;

    public String validator() {
        return "SELECT '-' AS version";
    }

    public String name() {
        return "Druid";
    }

    public String description() {
        return "Integrate Druid data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("org.apache.calcite.avatica.remote.Driver");
            this.jdbcConfigure.setJdbcType("avatica:remote:url=http");
            this.connection = new DruidConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.connection))) {
            log.info("Execute druid plugin logic started");
            this.response = this.connection.getResponse();
            DruidAdapter processor = new DruidAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute druid plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.connection))) {
            this.connection.destroy();
        }
    }
}

