/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.http.clickhouse;

import com.google.common.base.Preconditions;
import io.edurt.datacap.spi.adapter.HttpAdapter;
import io.edurt.datacap.spi.connection.HttpConfigure;
import io.edurt.datacap.spi.connection.HttpConnection;
import io.edurt.datacap.spi.connection.http.HttpClient;
import io.edurt.datacap.spi.connection.http.HttpMethod;
import io.edurt.datacap.spi.model.Response;
import io.edurt.datacap.spi.model.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import okhttp3.MediaType;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseAdapter
extends HttpAdapter {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseAdapter.class);

    public ClickHouseAdapter(HttpConnection httpConnection) {
        super(httpConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handlerExecute(String content) {
        Time processorTime = new Time();
        processorTime.setStart(new Date().getTime());
        Response response = this.httpConnection.getResponse();
        HttpConfigure httpConfigure = new HttpConfigure();
        if (response.getIsConnected().booleanValue()) {
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<Object> columns = new ArrayList<Object>();
            try {
                BeanUtils.copyProperties((Object)httpConfigure, (Object)this.httpConnection.getConfigure());
                httpConfigure.setAutoConnected(Boolean.FALSE);
                httpConfigure.setRetry(Integer.valueOf(0));
                httpConfigure.setMethod(HttpMethod.POST);
                httpConfigure.setJsonBody(content + " FORMAT TabSeparatedWithNamesAndTypes");
                httpConfigure.setMediaType(MediaType.parse((String)"text/plain; charset=utf-8"));
                HttpConnection httpConnection = new HttpConnection(httpConfigure, new Response());
                HttpClient httpClient = HttpClient.getInstance((HttpConfigure)httpConfigure, (HttpConnection)httpConnection);
                String responseBody = httpClient.execute();
                Preconditions.checkArgument((!responseBody.contains("DB::Exception") ? 1 : 0) != 0, (Object)responseBody);
                String[] data = responseBody.split("\n");
                for (int i = 0; i < data.length; ++i) {
                    if (i == 0) {
                        headers.addAll(Arrays.asList(data[i].split("\t")));
                        continue;
                    }
                    if (i == 1) {
                        types.addAll(Arrays.asList(data[i].split("\t")));
                        continue;
                    }
                    columns.add(this.handlerFormatter(httpConfigure.getFormat(), headers, Arrays.asList(data[i].split("\t"))));
                }
                response.setIsSuccessful(Boolean.TRUE);
            }
            catch (Exception ex) {
                log.error("Execute content failed content {} exception ", (Object)content, (Object)ex);
                response.setIsSuccessful(Boolean.FALSE);
                response.setMessage(ex.getMessage());
            }
            finally {
                response.setHeaders(headers);
                response.setTypes(types);
                response.setColumns(columns);
            }
        }
        processorTime.setEnd(new Date().getTime());
        response.setProcessor(processorTime);
        return response;
    }
}

