/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.audit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import eu.bitwalker.useragentutils.UserAgent;
import io.edurt.datacap.server.audit.AuditUserLog;
import io.edurt.datacap.server.common.Response;
import io.edurt.datacap.server.common.State;
import io.edurt.datacap.server.entity.UserLogEntity;
import io.edurt.datacap.server.repository.UserLogRepository;
import io.edurt.datacap.server.security.UserDetailsService;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@Component
@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="I prefer to suppress these FindBugs warnings")
public class AuditUserLogHandler {
    private static final Logger log = LoggerFactory.getLogger(AuditUserLogHandler.class);
    private final UserLogRepository userLogRepository;
    private UserLogEntity userLogEntity;

    public AuditUserLogHandler(UserLogRepository userLogRepository) {
        this.userLogRepository = userLogRepository;
    }

    @Pointcut(value="@annotation(auditUserLog)")
    public void cut(AuditUserLog auditUserLog) {
    }

    @Before(value="cut(auditUserLog)")
    public void doBefore(AuditUserLog auditUserLog) {
        this.userLogEntity = new UserLogEntity();
        this.userLogEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
    }

    @AfterReturning(pointcut="@annotation(auditUserLog)", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, AuditUserLog auditUserLog, Response jsonResult) {
        this.handlerPlugin(joinPoint, this.userLogEntity, jsonResult);
    }

    protected void handlerPlugin(JoinPoint joinPoint, UserLogEntity userLogEntity, Response jsonResult) {
        try {
            if (jsonResult.getStatus().booleanValue()) {
                userLogEntity.setState(State.SUCCESS);
                userLogEntity.setUser(UserDetailsService.getUser());
            } else {
                userLogEntity.setMessage(jsonResult.getMessage().toString());
                userLogEntity.setState(State.FAILURE);
            }
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
            userLogEntity.setIp(this.getIpAddress(request));
            userLogEntity.setUa(request.getHeader("user-agent"));
            UserAgent userAgent = UserAgent.parseUserAgentString((String)userLogEntity.getUa());
            userLogEntity.setClient(userAgent.getBrowser().getName());
            userLogEntity.setDevice(userAgent.getOperatingSystem().getDeviceType().getName());
            this.userLogRepository.save(userLogEntity);
        }
        catch (Exception ex) {
            log.error("Audit failed ", (Throwable)ex);
        }
    }

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_CLUSTER_CLIENT_IP");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_FORWARDED_FOR");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_FORWARDED");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_VIA");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("REMOTE_ADDR");
        }
        if (ObjectUtils.isEmpty((Object)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.contains(",")) {
            return ip.split(",")[0];
        }
        return ip;
    }
}

