/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCommon {
    private static final Logger log = LoggerFactory.getLogger(ResourceCommon.class);

    private ResourceCommon() {
    }

    public static String loadResourceToString(String resource, boolean absolute) {
        try {
            if (absolute) {
                return IOUtils.toString((InputStream)Files.newInputStream(new File(resource).toPath(), new OpenOption[0]));
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = loader.getResourceAsStream(resource);
            return IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException | NullPointerException e) {
            log.error("Loading file error {}", (Object)resource);
            return null;
        }
    }

    public static boolean checkExists(String resource) {
        return !ObjectUtils.isEmpty((Object)ResourceCommon.loadResourceToString(resource, false));
    }
}

