/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.entity;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.edurt.datacap.server.common.FunctionType;
import io.edurt.datacap.server.validation.ValidationGroup;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="functions")
@org.hibernate.annotations.Table(appliesTo="functions", comment="Plug-in correlation function")
@SuppressFBWarnings(value={"EI_EXPOSE_REP", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="I prefer to suppress these FindBugs warnings")
public class FunctionsEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty")
    private @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty") Long id;
    @NotBlank(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class})
    @Column(name="name")
    private String name;
    @NotBlank(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class})
    @Column(name="content")
    private String content;
    @NotBlank(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class})
    @Column(name="description")
    private String description;
    @NotNull(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class})
    @Size(min=1)
    @Column(name="plugin")
    private @NotNull(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class}) @Size(min=1) String plugin;
    @NotBlank(groups={ValidationGroup.Crud.Create.class, ValidationGroup.Crud.Update.class})
    @Column(name="example")
    private String example;
    @Column(name="type", unique=true)
    @Enumerated(value=EnumType.STRING)
    private FunctionType type = FunctionType.KEYWORD;
    @Column(name="create_time", columnDefinition="timestamp not null default current_timestamp")
    private Timestamp createTime;
    @Column(name="update_time", columnDefinition="timestamp not null default current_timestamp")
    private Timestamp updateTime;

    public List<String> getPlugin() {
        return Arrays.asList(this.plugin.split(","));
    }

    public void setPlugin(List<String> plugin) {
        this.plugin = String.join((CharSequence)",", plugin);
    }

    @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty")
    public @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty") Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExample() {
        return this.example;
    }

    public FunctionType getType() {
        return this.type;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public void setId(@NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty") @NotNull(groups={ValidationGroup.Crud.Update.class}, message="The passed source id cannot be empty") Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public void setType(FunctionType type) {
        this.type = type;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Timestamp updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionsEntity)) {
            return false;
        }
        FunctionsEntity other = (FunctionsEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$plugin = this.getPlugin();
        List<String> other$plugin = other.getPlugin();
        if (this$plugin == null ? other$plugin != null : !((Object)this$plugin).equals(other$plugin)) {
            return false;
        }
        String this$example = this.getExample();
        String other$example = other.getExample();
        if (this$example == null ? other$example != null : !this$example.equals(other$example)) {
            return false;
        }
        FunctionType this$type = this.getType();
        FunctionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Timestamp this$createTime = this.getCreateTime();
        Timestamp other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Timestamp this$updateTime = this.getUpdateTime();
        Timestamp other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionsEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : ((Object)$plugin).hashCode());
        String $example = this.getExample();
        result = result * 59 + ($example == null ? 43 : $example.hashCode());
        FunctionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Timestamp $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Timestamp $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "FunctionsEntity(id=" + this.getId() + ", name=" + this.getName() + ", content=" + this.getContent() + ", description=" + this.getDescription() + ", plugin=" + this.getPlugin() + ", example=" + this.getExample() + ", type=" + (Object)((Object)this.getType()) + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

