/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.security;

import io.edurt.datacap.server.security.UserDetailsService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class JwtService {
    private static final Logger log = LoggerFactory.getLogger(JwtService.class);
    @Value(value="${datacap.security.secret}")
    private String jwtSecret = "DataCapSecretKey";
    @Value(value="${datacap.security.expiration}")
    private int jwtExpirationMs = 86400000;

    public String generateJwtToken(Authentication authentication) {
        UserDetailsService userPrincipal = (UserDetailsService)authentication.getPrincipal();
        return Jwts.builder().setSubject(userPrincipal.getUsername()).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + (long)this.jwtExpirationMs)).signWith(SignatureAlgorithm.HS512, this.jwtSecret).compact();
    }

    public String getUserNameFromJwtToken(String token) {
        return ((Claims)Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(token).getBody()).getSubject();
    }

    public boolean validateJwtToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.jwtSecret).parseClaimsJws(authToken);
            return true;
        }
        catch (SignatureException e) {
            log.error("Invalid JWT signature: {}", (Object)e.getMessage());
        }
        catch (MalformedJwtException e) {
            log.error("Invalid JWT token: {}", (Object)e.getMessage());
        }
        catch (ExpiredJwtException e) {
            log.error("JWT token is expired: {}", (Object)e.getMessage());
        }
        catch (UnsupportedJwtException e) {
            log.error("JWT token is unsupported: {}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.error("JWT claims string is empty: {}", (Object)e.getMessage());
        }
        return false;
    }
}

