/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.adapter;

import io.edurt.datacap.common.CollectorUtils;
import io.edurt.datacap.server.body.FilterBody;
import java.util.ArrayList;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class PageRequestAdapter {
    private PageRequestAdapter() {
    }

    public static PageRequest of(int start, int end) {
        if (start > 0) {
            --start;
        }
        return PageRequest.of((int)start, (int)end);
    }

    public static PageRequest of(int start, int end, Sort sort) {
        if (start > 0) {
            --start;
        }
        return PageRequest.of((int)start, (int)end, (Sort)sort);
    }

    public static PageRequest of(FilterBody filter) {
        PageRequest pageable = PageRequestAdapter.of(filter.getPage(), filter.getSize());
        if (ObjectUtils.isNotEmpty(filter.getOrders())) {
            ArrayList remoted = new ArrayList();
            filter.getOrders().stream().filter(CollectorUtils.distinctByKey(p -> p.getColumn())).forEach(remoted::add);
            ArrayList orders = new ArrayList();
            remoted.stream().filter(value -> value.getOrder().equalsIgnoreCase("asc") || value.getOrder().equalsIgnoreCase("desc")).forEach(value -> {
                if (value.getOrder().equalsIgnoreCase("desc")) {
                    orders.add(Sort.Order.desc((String)value.getColumn()));
                } else {
                    orders.add(Sort.Order.asc((String)value.getColumn()));
                }
            });
            Sort sort = Sort.by(orders);
            pageable = PageRequestAdapter.of(filter.getPage(), filter.getSize(), sort);
        }
        return pageable;
    }
}

