/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.lang3.StringUtils;

@SuppressFBWarnings(value={"ME_ENUM_FIELD_SETTER"}, justification="I prefer to suppress these FindBugs warnings")
public class AiSupportCommon {
    private AiSupportCommon() {
    }

    public static String getValue(String locale, AiSupportEnum supportType) {
        if (StringUtils.isEmpty((CharSequence)locale)) {
            return supportType.enValue;
        }
        if (locale.equalsIgnoreCase("zh")) {
            return supportType.zhValue;
        }
        return supportType.enValue;
    }

    public static enum AiSupportEnum {
        OPTIMIZE("\u4f18\u5316\u4ee5\u4e0bSQL\n${sql}\n\u8f93\u51fa\u4e3amarkdown\n\u5f15\u64ce\u662f${engine}", "Help me optimize the following SQL\n${sql}\noutput is markdown\nThe engine is ${engine}"),
        ANALYSIS("\u89e3\u6790\u4ee5\u4e0bSQL\n${sql}\n\u8f93\u51fa\u4e3amarkdown\n\u5f15\u64ce\u662f${engine}", "Help me analyze the following SQL\n${sql}\noutput is markdown\nThe engine is ${engine}"),
        TRANSLATOR("\u5c06\u6b64SQL\u67e5\u8be2\u7ffb\u8bd1\u6210\u81ea\u7136\u8bed\u8a00\n${sql}\n\u8f93\u51fa\u4e3amarkdown", "Translate this SQL query into natural language\n${sql}\noutput is markdown"),
        FINDBUGS("\u67e5\u627e\u4ee5\u4e0bSQL\u51fa\u73b0\u7684\u9519\u8bef\u4fe1\u606f\n${sql}\n\u8f93\u51fa\u4e3amarkdown\n\u5f15\u64ce\u662f${engine}", "Find the error message that appears in the following SQL\n${sql}\nThe output is markdown\nThe engine is ${engine}"),
        FIXEDBUGS("\u4fee\u590d\u4e00\u4e0bSQL\u51fa\u73b0\u7684\u9519\u8bef\n${sql}\n\u8f93\u51fa\u8fd4\u56de\u7ed3\u679c\u5185\u5bb9\u4e3amarkdown\n\u5f15\u64ce\u662f${engine}\n\u51fa\u73b0\u7684\u9519\u8bef\u662f\n${error}", "Fix the error in SQL\n${sql}\nThe output returns the result content as markdown\nThe engine is ${engine}\nThe error that occurred is\n${error}");

        private String zhValue;
        private String enValue;

        private AiSupportEnum(String zhValue, String enValue) {
            this.zhValue = zhValue;
            this.enValue = enValue;
        }

        public String getZhValue() {
            return this.zhValue;
        }

        public void setZhValue(String zhValue) {
            this.zhValue = zhValue;
        }

        public String getEnValue() {
            return this.enValue;
        }

        public void setEnValue(String enValue) {
            this.enValue = enValue;
        }
    }
}

