/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.common;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;

public class BeanToPropertiesCommon {
    private BeanToPropertiesCommon() {
    }

    public static Properties convertBeanToProperties(Object bean) {
        Properties properties = new Properties();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Object value;
                Method readMethod;
                String propertyName = propertyDescriptor.getName();
                if (propertyDescriptor.getPropertyType().getName().startsWith("io\\.edurt\\.datacap") || propertyName.equals("class") || (readMethod = propertyDescriptor.getReadMethod()).getGenericReturnType().getTypeName().contains("io.edurt.datacap") || !ObjectUtils.isNotEmpty((Object)(value = readMethod.invoke(bean, new Object[0])))) continue;
                properties.setProperty(propertyName, value.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return properties;
    }
}

