/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import io.edurt.datacap.server.common.JSON;
import io.edurt.datacap.server.common.ResourceCommon;
import io.edurt.datacap.server.plugin.configure.IConfigure;
import io.edurt.datacap.spi.Plugin;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class PluginCommon {
    private static final Logger log = LoggerFactory.getLogger(PluginCommon.class);
    private static final ObjectMapper yamlFactory = new ObjectMapper((JsonFactory)new YAMLFactory());

    private PluginCommon() {
    }

    public static Optional<Plugin> getPluginByName(Injector injector, String pluginName) {
        Optional<Plugin> pluginOptional = ((Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Plugin>>(){}))).stream().filter(plugin -> plugin.name().equalsIgnoreCase(pluginName)).findFirst();
        return pluginOptional;
    }

    public static Optional<Plugin> getPluginByNameAndType(Injector injector, String pluginName, String pluginType) {
        Optional<Plugin> pluginOptional = ((Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Plugin>>(){}))).stream().filter(plugin -> plugin.name().equalsIgnoreCase(pluginName) && plugin.type().name().equalsIgnoreCase(pluginType)).findFirst();
        return pluginOptional;
    }

    @Deprecated
    public static IConfigure loadConfigure(String type, String plugin, String resource, Environment environment) {
        String root = environment.getProperty("spring.config.location");
        if (!resource.endsWith(".json")) {
            resource = resource + ".json";
        }
        String path = root + String.format("plugins/%s/%s", type.toLowerCase(), resource.toLowerCase());
        log.info("Load plugin {} type {} resource {} configure file path {}", new Object[]{plugin, type, resource, path});
        String json = ResourceCommon.loadResourceToString(path, true);
        if (StringUtils.isEmpty((CharSequence)json)) {
            log.warn("Plugin {} type {} configuration file {} not found, load default configuration file", new Object[]{plugin, type, resource});
            json = ResourceCommon.loadResourceToString(root + "plugins/default.json", true);
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)json), (Object)"Invalid configuration file, it may be a bug, please submit issues to solve it.");
        IConfigure configure = null;
        try {
            configure = (IConfigure)JSON.objectmapper.readValue(json, IConfigure.class);
        }
        catch (JsonProcessingException e) {
            log.error("Format configuration file, it may be a bug, please submit issues to solve it. plugin {} type {} resource {} configure file path {} message ", new Object[]{plugin, type, resource, path, e});
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)json), (Object)"Format configuration file, it may be a bug, please submit issues to solve it.");
        }
        return configure;
    }

    public static IConfigure loadYamlConfigure(String type, String plugin, String resource, Environment environment) {
        String path;
        File file;
        String root = environment.getProperty("spring.config.location");
        if (!resource.endsWith(".yaml")) {
            resource = resource + ".yaml";
        }
        if (!(file = new File(path = root + String.format("plugins/%s/%s", type.toLowerCase(), resource.toLowerCase()))).exists()) {
            log.warn("Plugin {} type {} configuration file {} not found, load default configuration file", new Object[]{plugin, type, resource});
            file = new File(root + "plugins/default.yaml");
        } else {
            log.info("Load plugin {} type {} resource {} configure file path {}", new Object[]{plugin, type, resource, path});
        }
        yamlFactory.findAndRegisterModules();
        IConfigure configure = null;
        try {
            configure = (IConfigure)yamlFactory.readValue(file, IConfigure.class);
        }
        catch (Exception e) {
            log.error("Format configuration file, it may be a bug, please submit issues to solve it. plugin {} type {} resource {} configure file path {} message ", new Object[]{plugin, type, resource, path, e});
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)path), (Object)"Format configuration file, it may be a bug, please submit issues to solve it.");
        }
        return configure;
    }
}

