/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.server.entity;

import java.util.List;
import org.springframework.data.domain.Page;

public class PageEntity<T> {
    private int page;
    private int size;
    private long total;
    private long totalPage;
    private List<T> content;

    private PageEntity() {
    }

    public static PageEntity build(Page page) {
        PageEntity pageEntity = new PageEntity();
        pageEntity.setPage(page.getNumber());
        pageEntity.setSize(page.getSize());
        pageEntity.setTotal(page.getTotalElements());
        pageEntity.setTotalPage(page.getTotalPages());
        pageEntity.setContent(page.getContent());
        return pageEntity;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public long getTotal() {
        return this.total;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public List<T> getContent() {
        return this.content;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageEntity)) {
            return false;
        }
        PageEntity other = (PageEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        List<T> this$content = this.getContent();
        List<T> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $totalPage = this.getTotalPage();
        result = result * 59 + (int)($totalPage >>> 32 ^ $totalPage);
        List<T> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "PageEntity(page=" + this.getPage() + ", size=" + this.getSize() + ", total=" + this.getTotal() + ", totalPage=" + this.getTotalPage() + ", content=" + this.getContent() + ")";
    }
}

